/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.cms.util.Util;
import com.arsdigita.forum.Forum;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portal.PortletType;
import com.arsdigita.portal.apportlet.AppPortletType;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringArrayParameter;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Logger;

public class Loader
extends PackageLoader {
    private final Parameter m_forumInstances = new StringArrayParameter("com.arsdigita.forum.forum_names", 0, (Object)new String[0]);
    private static final Logger s_log = Logger.getLogger(Loader.class);

    public Loader() {
        s_log.debug((Object)"forum.Loader (Constructor) invoked");
        this.register(this.m_forumInstances);
        s_log.debug((Object)"forum.Loader (Constructor) completed");
    }

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Loader.setupPrivileges();
                Loader.setupDigestUser();
                Loader.setupForumAppType((String[])Loader.this.get(Loader.this.m_forumInstances));
                Loader.setupRecentPostingsPortletType();
                Loader.setupMyForumsPortletType();
                SessionManager.getSession().flushAll();
            }
        }.run();
    }

    private static void setupForumAppType(String[] forumNames) {
        ApplicationType type = new ApplicationType("Forum", "com.arsdigita.forum.Forum");
        type.setDescription("An electronic bulletin board system (disussion forum).");
        type.save();
        for (int i = 0; i < forumNames.length; ++i) {
            String forumName = forumNames[i];
            Util.validateURLParameter((String)"name", (String)forumName);
            s_log.info((Object)("Creating forum instance on /" + forumName));
            Forum.create(forumName, forumName, null);
        }
        s_log.info((Object)"Forum setup completed");
    }

    public static AppPortletType setupRecentPostingsPortletType() {
        AppPortletType type = AppPortletType.createAppPortletType((String)"Recent Forum Postings", (String)"wide", (String)"com.arsdigita.forum.RecentPostingsPortlet");
        type.setProviderApplicationType("com.arsdigita.forum.Forum");
        type.setPortalApplication(true);
        type.setDescription("Displays the most recent postings to the bulletin board.");
        return type;
    }

    public static PortletType setupMyForumsPortletType() {
        PortletType type = PortletType.createPortletType((String)"My Forums", (String)"wide", (String)"com.arsdigita.forum.MyForumsPortlet");
        type.setDescription("Lists forums that user has access to,            with last posting date");
        return type;
    }

    private static void setupDigestUser() {
        s_log.debug((Object)"Setting up the digest user");
        String email = Forum.getConfig().getDigestUserEmail();
        UserCollection users = User.retrieveAll();
        users.addEqualsFilter("primaryEmail", (Object)email);
        if (users.next()) {
            s_log.debug((Object)"user exists");
        } else {
            s_log.debug((Object)("Creating a user with the email " + email));
            User user = new User();
            user.setPrimaryEmail(new EmailAddress(email));
            user.getPersonName().setGivenName("Forum");
            user.getPersonName().setFamilyName("Digest Sender");
            user.setScreenName("Forum");
            users.close();
        }
    }

    public static void setupPrivileges() {
        PrivilegeDescriptor.createPrivilege((String)"forum_read");
        PrivilegeDescriptor.createPrivilege((String)"forum_moderation");
        PrivilegeDescriptor.createPrivilege((String)"forum_create_thread");
        PrivilegeDescriptor.createPrivilege((String)"forum_respond");
        PrivilegeDescriptor.addChildPrivilege((String)"forum_moderation", (String)"forum_create_thread");
        PrivilegeDescriptor.addChildPrivilege((String)"forum_create_thread", (String)"forum_respond");
        PrivilegeDescriptor.addChildPrivilege((String)"forum_respond", (String)PrivilegeDescriptor.READ.getName());
        PrivilegeDescriptor.addChildPrivilege((String)"forum_respond", (String)"forum_read");
    }
}

