/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.cms.FileAsset;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.Post;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class PostFileAttachment
extends FileAsset {
    private static final Logger s_log = Logger.getLogger(PostFileAttachment.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.PostFileAttachment";
    public static final String FILE_OWNER = "fileMessage";
    public static final String FILE_ORDER = "fileOrder";

    public PostFileAttachment() {
        super(BASE_DATA_OBJECT_TYPE);
        this.setVersion("draft");
    }

    public PostFileAttachment(OID oid) {
        super(oid);
    }

    public PostFileAttachment(BigDecimal id) {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public PostFileAttachment(DataObject obj) {
        super(obj);
    }

    public PostFileAttachment(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void setFileOrder(Integer order) {
        this.set(FILE_ORDER, order);
    }

    public void setFileOrder(int order) {
        this.set(FILE_ORDER, new Integer(order));
    }

    public void setLive() {
        this.setVersion("live");
    }

    public void setDraft() {
        this.setVersion("draft");
    }

    public Post getOwner() {
        return (Post)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(FILE_OWNER)));
    }

    protected static void removeUnattachedFiles() {
        s_log.debug((Object)"removing orphaned files created more than a day ago");
        DataCollection files = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(5, -1);
        files.addFilter(files.getFilterFactory().lessThan("auditing.creationDate", (Object)yesterday.getTime(), false));
        files.addEqualsFilter(FILE_OWNER, null);
        while (files.next()) {
            s_log.debug((Object)"deleting one");
            DomainObjectFactory.newInstance((DataObject)files.getDataObject()).delete();
        }
    }
}

