/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.web.Application;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;

public class PostFinder
implements URLFinder {
    public String find(OID oid, String context) throws NoValidURLException {
        return this.find(oid);
    }

    public String find(OID oid) throws NoValidURLException {
        DataObject dobj = SessionManager.getSession().retrieve(oid);
        if (dobj == null) {
            throw new NoValidURLException("No such data object " + oid);
        }
        Application app = Application.retrieveApplication((DataObject)dobj);
        if (app == null) {
            throw new NoValidURLException("Could not find application instance for " + dobj);
        }
        try {
            ThreadedMessage message = new ThreadedMessage(oid);
            ParameterMap params = new ParameterMap();
            params.setParameter("thread", message.getThread().getID().toString());
            return URL.there((String)("/" + app.getPath() + "/thread.jsp"), (ParameterMap)params).toString();
        }
        catch (DataObjectNotFoundException e) {
            throw new NoValidURLException("Could not find application instance for " + dobj);
        }
    }
}

