/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.cms.ImageAsset;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.Post;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class PostImageAttachment
extends ImageAsset {
    private static final Logger s_log = Logger.getLogger(PostImageAttachment.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.forum.PostImageAttachment";
    public static final String IMAGE_OWNER = "imageMessage";
    public static final String IMAGE_ORDER = "imageOrder";

    public PostImageAttachment() {
        super(BASE_DATA_OBJECT_TYPE);
        this.setVersion("draft");
    }

    public PostImageAttachment(OID oid) {
        super(oid);
    }

    public PostImageAttachment(BigDecimal id) {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public PostImageAttachment(DataObject obj) {
        super(obj);
    }

    public PostImageAttachment(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void setImageOrder(Integer order) {
        this.set(IMAGE_ORDER, order);
    }

    public void setImageOrder(int order) {
        this.set(IMAGE_ORDER, new Integer(order));
    }

    public Post getOwner() {
        return (Post)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(IMAGE_OWNER)));
    }

    protected static void removeUnattachedImages() {
        s_log.debug((Object)"removing orphaned images created more than a day ago");
        DataCollection images = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(5, -1);
        images.addFilter(images.getFilterFactory().lessThan("auditing.creationDate", (Object)yesterday.getTime(), false));
        images.addEqualsFilter(IMAGE_OWNER, null);
        while (images.next()) {
            s_log.debug((Object)"deleting one");
            DomainObjectFactory.newInstance((DataObject)images.getDataObject()).delete();
        }
    }
}

