/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.PageBuilder;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.DiscussionThreadSimpleView;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.toolbox.ui.ApplicationAuthenticationListener;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class ThreadPageBuilder
implements PageBuilder,
Constants {
    @Override
    public Page buildPage() {
        Page threadPage = PageFactory.buildPage((String)"forum", (String)"Threads", (String)"forumThreadPage");
        threadPage.add((Component)new SimpleComponent(){

            public void generateXML(PageState state, Element parent) {
                Element nameElement = parent.newChildElement("forum:name", "http://www.arsdigita.com/forum/1.0");
                nameElement.setText(ForumContext.getContext(state).getForum().getTitle());
                Element introductionElement = parent.newChildElement("forum:introduction", "http://www.arsdigita.com/forum/1.0");
                introductionElement.setText(ForumContext.getContext(state).getForum().getIntroduction());
            }
        });
        threadPage.add((Component)new DiscussionThreadSimpleView());
        BigDecimalParameter threadID = new BigDecimalParameter("thread");
        threadPage.addGlobalStateParam((ParameterModel)threadID);
        threadPage.addRequestListener((RequestListener)new ApplicationAuthenticationListener(PrivilegeDescriptor.READ));
        threadPage.addRequestListener((RequestListener)new ThreadPageRequestListener(threadID));
        return threadPage;
    }

    private static class ThreadPageRequestListener
    implements RequestListener {
        private BigDecimalParameter m_threadID;

        public ThreadPageRequestListener(BigDecimalParameter threadID) {
            this.m_threadID = threadID;
        }

        public void pageRequested(RequestEvent event) {
            PageState state = event.getPageState();
            ForumContext context = ForumContext.getContext(state);
            context.setThreadID((BigDecimal)event.getPageState().getValue((ParameterModel)this.m_threadID));
        }
    }
}

