/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.portlet;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ThreadCollection;
import com.arsdigita.forum.portlet.MyForumsPortlet;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.web.Application;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.formatters.DateFormatter;

class MyForumsPortletRenderer
extends AbstractPortletRenderer
implements Constants {
    private MyForumsPortlet m_portlet;

    public MyForumsPortletRenderer(MyForumsPortlet portlet) {
        this.m_portlet = portlet;
    }

    protected void generateBodyXML(PageState pageState, Element parent) {
        Element content = parent.newChildElement("forum:myForumsPortlet", "http://www.arsdigita.com/forum/1.0");
        Party party = Kernel.getContext().getParty();
        if (party == null) {
            party = Kernel.getPublicUser();
        }
        DataCollection forums = SessionManager.getSession().retrieve("com.arsdigita.forum.Forum");
        forums.addOrder("lower(title)");
        PermissionService.filterObjects((DataCollection)forums, (PrivilegeDescriptor)PrivilegeDescriptor.READ, (OID)party.getOID());
        while (forums.next()) {
            Forum forum = (Forum)DomainObjectFactory.newInstance((DataObject)forums.getDataObject());
            Element forumEl = content.newChildElement("forum:forumShortcut", "http://www.arsdigita.com/forum/1.0");
            URL url = URL.there((Application)forum, (String)"/", null);
            forumEl.addAttribute("url", url.toString());
            forumEl.addAttribute("title", forum.getTitle());
            ThreadCollection threads = forum.getThreads();
            threads.addOrder("lastUpdate");
            if (threads.next()) {
                MessageThread lastUpdatedThread = threads.getMessageThread();
                forumEl.addAttribute("lastUpdated", new DateFormatter().format((Object)lastUpdatedThread.getLatestUpdateDate()));
                threads.close();
                continue;
            }
            forumEl.addAttribute("lastUpdated", "");
        }
    }
}

