/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.portlet;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ThreadCollection;
import com.arsdigita.forum.portlet.RecentPostingsPortlet;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ThreadsList;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.web.Application;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;

class RecentPostingsPortletRenderer
extends AbstractPortletRenderer
implements Constants {
    private RecentPostingsPortlet m_portlet;

    public RecentPostingsPortletRenderer(RecentPostingsPortlet recentPostingsPortlet) {
        this.m_portlet = recentPostingsPortlet;
    }

    protected void generateBodyXML(PageState pageState, Element parent) {
        Element content = parent.newChildElement("forum:recentPostingsPortlet", "http://www.arsdigita.com/forum/1.0");
        Forum forum = (Forum)this.m_portlet.getParentApplication();
        content.addAttribute("noticeboard", new Boolean(forum.isNoticeboard()).toString());
        content.addAttribute("forumName", forum.getTitle());
        Party party = Kernel.getContext().getParty();
        ThreadCollection threads = forum.getThreads(Kernel.getContext().getParty());
        threads.setRange(new Integer(1), new Integer(this.m_portlet.getNumPosts() + 1));
        while (threads.next()) {
            MessageThread thread = threads.getMessageThread();
            Element threadEl = content.newChildElement("forum:thread", "http://www.arsdigita.com/forum/1.0");
            ParameterMap map = new ParameterMap();
            map.setParameter("thread", (Object)thread.getID());
            URL url = URL.there((Application)forum, (String)"/thread.jsp", (ParameterMap)map);
            threadEl.addAttribute("url", url.toString());
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(threadEl);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk((DomainObject)thread, ThreadsList.class.getName());
        }
    }
}

