/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormStep;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.FileSizeValidationListener;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.PostFileAttachment;
import com.arsdigita.forum.ui.AttachedFilesTable;
import com.arsdigita.forum.ui.ConfirmStep;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.PostForm;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AttachedFilesStep
extends FormStep
implements Constants,
FormInitListener,
FormProcessListener,
FormValidationListener {
    private static Logger s_log = Logger.getLogger(AttachedFilesStep.class);
    private ACSObjectSelectionModel m_post;
    private AttachedFilesTable m_attachedFiles;
    private FileUpload m_upload;
    private TextArea m_description;
    private Submit m_addFile;
    private PostForm m_container;
    private ArrayParameter m_newFiles = new ArrayParameter("newFiles");
    private ArrayParameter m_existingFiles = new ArrayParameter("oldFiles");

    public AttachedFilesStep(ACSObjectSelectionModel post, PostForm container) {
        super("postFiles", (Container)new SimpleContainer("forum:postFormFiles", "http://www.arsdigita.com/forum/1.0"));
        this.m_post = post;
        this.m_container = container;
        this.m_attachedFiles = new AttachedFilesTable(this.m_newFiles, this.m_existingFiles, this);
        this.add((Component)this.m_attachedFiles);
        this.m_upload = new FileUpload("file", true);
        this.m_upload.addValidationListener((ParameterListener)new NotEmptyValidationListener(Text.gz("forum.ui.validation.file_null")){

            public void validate(ParameterEvent e) {
                if (AttachedFilesStep.this.m_addFile.isSelected(e.getPageState())) {
                    super.validate(e);
                }
            }
        });
        this.m_upload.addValidationListener((ParameterListener)new FileSizeValidationListener(Forum.getConfig().getMaxFileSize()));
        this.add((Component)this.m_upload);
        this.m_description = new TextArea("fileDescription");
        this.m_description.setCols(20);
        this.m_description.setRows(5);
        this.m_description.addValidationListener((ParameterListener)new StringInRangeValidationListener(0, 4000, Text.gz("forum.ui.validation.file_description_too_long")){

            public void validate(ParameterEvent e) throws FormProcessException {
                if (AttachedFilesStep.this.m_addFile.isSelected(e.getPageState())) {
                    super.validate(e);
                }
            }
        });
        this.add((Component)this.m_description);
        this.m_addFile = new Submit("Add File");
        this.add((Component)this.m_addFile);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        if (this.m_addFile.isSelected(state)) {
            s_log.debug((Object)"adding file");
            try {
                String fileName = (String)this.m_upload.getValue(state);
                s_log.debug((Object)("filename is " + fileName));
                File file = ((MultipartHttpServletRequest)e.getPageState().getRequest()).getFile("file");
                s_log.debug((Object)("uploaded file is " + file.getName()));
                PostFileAttachment attachment = new PostFileAttachment();
                attachment.loadFromFile(fileName, file, "application/octet-stream");
                attachment.setDescription((String)this.m_description.getValue(state));
                BigDecimal id = attachment.getID();
                String[] current = (String[])state.getValue((ParameterModel)this.m_newFiles);
                if (current == null) {
                    current = new String[]{id.toString()};
                } else {
                    List<String> files = Arrays.asList(current);
                    current = new String[files.size() + 1];
                    Iterator<String> it = files.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        current[i++] = it.next();
                    }
                    current[i] = id.toString();
                }
                state.setValue((ParameterModel)this.m_newFiles, (Object)current);
                s_log.debug((Object)"File Uploaded");
                this.m_description.setValue(state, null);
            }
            catch (Exception ex) {
                throw new FormProcessException((Throwable)ex);
            }
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (!this.m_addFile.isSelected(state) && StringUtils.isNotBlank((String)((String)this.m_upload.getValue(state)))) {
            throw new FormProcessException((String)Text.gz("forum.ui.validation.file_not_uploaded").localize());
        }
    }

    public void removeFile(BigDecimal id, PageState state) {
        List<String> existing;
        String[] existingArray = (String[])state.getValue((ParameterModel)this.m_existingFiles);
        if (existingArray != null && !(existing = Arrays.asList(existingArray)).contains(id)) {
            s_log.debug((Object)"new file - I will actually delete it");
            PostFileAttachment attachment = new PostFileAttachment(id);
            attachment.delete();
        }
        Assert.exists((Object)state.getValue((ParameterModel)this.m_newFiles));
        ArrayList<String> newFiles = new ArrayList<String>(Arrays.asList((String[])state.getValue((ParameterModel)this.m_newFiles)));
        newFiles.remove(id);
        String[] current = new String[newFiles.size()];
        Iterator it = newFiles.iterator();
        int i = 0;
        while (it.hasNext()) {
            current[i++] = (String)it.next();
        }
        s_log.debug((Object)("size of new files array = " + current.length));
        state.setValue((ParameterModel)this.m_newFiles, (Object)current);
    }

    public DataCollection getCurrentFiles(PageState state) {
        String[] currentArray = (String[])state.getValue((ParameterModel)this.m_newFiles);
        if (currentArray != null && currentArray.length != 0) {
            List<String> current = Arrays.asList((String[])state.getValue((ParameterModel)this.m_newFiles));
            DataCollection files = SessionManager.getSession().retrieve("com.arsdigita.forum.PostFileAttachment");
            files.addFilter("id in :files").set("files", current);
            return files;
        }
        return null;
    }

    public void attachFiles(Post post, PageState state) {
        PostFileAttachment file;
        String[] existing;
        ArrayList<String> newFiles = Collections.EMPTY_LIST;
        String[] newFilesArray = (String[])state.getValue((ParameterModel)this.m_newFiles);
        if (newFilesArray != null) {
            newFiles = new ArrayList<String>(Arrays.asList(newFilesArray));
        }
        if ((existing = (String[])state.getValue((ParameterModel)this.m_existingFiles)) != null) {
            for (int i = 0; i < existing.length; ++i) {
                if (newFiles.contains(existing[i])) {
                    newFiles.remove(existing[i]);
                    continue;
                }
                file = new PostFileAttachment(new BigDecimal(existing[i]));
                post.removeFile(file);
            }
        }
        Iterator it = newFiles.iterator();
        while (it.hasNext()) {
            file = new PostFileAttachment(new BigDecimal((String)it.next()));
            post.addFile(file);
        }
        state.setValue((ParameterModel)this.m_newFiles, null);
        state.setValue((ParameterModel)this.m_existingFiles, null);
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_existingFiles);
        p.addGlobalStateParam((ParameterModel)this.m_newFiles);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        Post editPost;
        DataAssociationCursor files;
        PageState state = e.getPageState();
        if (this.m_container.getContext(state).equals("edit") && (files = (editPost = (Post)this.m_post.getSelectedObject(state)).getFiles()).size() > 0L) {
            String[] fileIDs = new String[new Long(files.size()).intValue()];
            int i = 0;
            while (files.next()) {
                PostFileAttachment file = (PostFileAttachment)DomainObjectFactory.newInstance((DataObject)files.getDataObject());
                fileIDs[i++] = file.getID().toString();
            }
            state.setValue((ParameterModel)this.m_existingFiles, (Object)fileIDs);
            state.setValue((ParameterModel)this.m_newFiles, (Object)fileIDs);
        }
    }

    public void generatePostXML(PageState state, Element p) {
        DataCollection files = this.getCurrentFiles(state);
        if (files == null) {
            return;
        }
        while (files.next()) {
            PostFileAttachment file = (PostFileAttachment)DomainObjectFactory.newInstance((DataObject)files.getDataObject());
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(p.newChildElement("forum:files", "http://www.arsdigita.com/forum/1.0"));
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk((DomainObject)file, ConfirmStep.class.getName());
        }
    }

    protected void clearParameters(PageState state) {
        state.setValue((ParameterModel)this.m_existingFiles, null);
        state.setValue((ParameterModel)this.m_newFiles, null);
    }
}

