/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.PostFileAttachment;
import com.arsdigita.forum.ui.AttachedFilesStep;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class AttachedFilesTable
extends SimpleComponent
implements Constants {
    private static Logger s_log = Logger.getLogger(AttachedFilesTable.class);
    protected static final String ACTION_DELETE = "delete";
    private ArrayParameter m_newFiles;
    private ArrayParameter m_existingFiles;
    private AttachedFilesStep m_parent;

    public AttachedFilesTable(ArrayParameter newFiles, ArrayParameter existingFiles, AttachedFilesStep parent) {
        this.m_newFiles = newFiles;
        this.m_existingFiles = existingFiles;
        this.m_parent = parent;
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        if (ACTION_DELETE.equals(key)) {
            List<String> existing = Collections.EMPTY_LIST;
            String[] existingArray = (String[])state.getValue((ParameterModel)this.m_existingFiles);
            if (existingArray != null) {
                existing = Arrays.asList(existingArray);
            }
            if (!existing.contains(value)) {
                OID oid = new OID("com.arsdigita.forum.PostFileAttachment", (Object)new BigDecimal(value));
                DomainObjectFactory.newInstance((OID)oid).delete();
            }
            ArrayList<String> newFiles = new ArrayList<String>(Arrays.asList((String[])state.getValue((ParameterModel)this.m_newFiles)));
            newFiles.remove(value);
            String[] current = new String[newFiles.size()];
            Iterator it = newFiles.iterator();
            int i = 0;
            while (it.hasNext()) {
                current[i++] = (String)it.next();
            }
            state.setValue((ParameterModel)this.m_newFiles, (Object)current);
        }
    }

    public void generateXML(PageState state, Element p) {
        Element mainElement = p.newChildElement("forum:attachedFiles", "http://www.arsdigita.com/forum/1.0");
        DataCollection files = this.m_parent.getCurrentFiles(state);
        if (files == null) {
            return;
        }
        while (files.next()) {
            PostFileAttachment file = (PostFileAttachment)DomainObjectFactory.newInstance((DataObject)files.getDataObject());
            Element fileElement = mainElement.newChildElement("forum:file", "http://www.arsdigita.com/forum/1.0");
            fileElement.addAttribute("name", file.getName());
            fileElement.addAttribute("url", Utilities.getAssetURL((BinaryAsset)file));
            fileElement.addAttribute("description", file.getDescription());
            this.generateActionXML(state, fileElement, file);
        }
    }

    private void generateActionXML(PageState state, Element parent, PostFileAttachment image) {
        parent.addAttribute("deleteLink", this.makeURL(state, ACTION_DELETE, image));
    }

    protected String makeURL(PageState state, String action, PostFileAttachment file) {
        state.setControlEvent((Component)this, action, file.getID().toString());
        String url = null;
        try {
            url = state.stateAsURL();
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot create url", (Throwable)ex);
        }
        state.clearControlEvent();
        return url;
    }
}

