/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.TooManyListenersException;

public class CategoryWidget
extends SingleSelect
implements Constants {
    public CategoryWidget(ParameterModel categoryParameter) {
        super(categoryParameter);
        try {
            this.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    Category root;
                    PageState s = e.getPageState();
                    Forum forum = CategoryWidget.this.getForum(s);
                    SingleSelect target = (SingleSelect)e.getTarget();
                    if (forum.noCategoryPostsAllowed()) {
                        target.addOption(new Option(Constants.TOPIC_NONE.toString(), (Component)new Label(Text.gz("forum.ui.topic.none"))));
                    }
                    if ((root = forum.getRootCategory()) != null) {
                        CategoryWidget.this.addCategories(root, target);
                    }
                }
            });
        }
        catch (TooManyListenersException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCategories(Category root, SingleSelect target) {
        CategoryCollection children = root.getChildren();
        try {
            while (children.next()) {
                Category c = children.getCategory();
                target.addOption(new Option(c.getID().toString(), c.getName()));
            }
        }
        finally {
            children.close();
        }
    }

    private Forum getForum(PageState s) {
        Forum forum;
        if (ForumContext.getContext(s).getThreadID() != null) {
            Post rootPost = (Post)ForumContext.getContext(s).getMessageThread().getRootMessage();
            forum = rootPost.getForum();
        } else if (ForumContext.getContext(s).getForum() != null) {
            forum = ForumContext.getContext(s).getForum();
        } else {
            throw new UncheckedWrapperException("Must be either a forum, or a thread page.");
        }
        return forum;
    }
}

