/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.DiscussionThreadSimpleView;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class DiscussionPostsList
extends SimpleComponent
implements Constants {
    private static final Logger s_log = Logger.getLogger(DiscussionPostsList.class);
    private IntegerParameter m_pageNumber = new IntegerParameter("page");
    private int m_pageSize = Forum.getConfig().getThreadPageSize();
    private static final String ACTION_EDIT = "edit";
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_REPLY = "reply";
    private static final String ACTION_APPROVE = "approve";
    private static final String ACTION_REJECT = "reject";
    private DiscussionThreadSimpleView m_threadMessagesPanel;
    private ACSObjectSelectionModel m_post;

    public DiscussionPostsList(ACSObjectSelectionModel post, DiscussionThreadSimpleView threadMessagesPanel) {
        this.m_threadMessagesPanel = threadMessagesPanel;
        this.m_post = post;
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_pageNumber);
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        String key = state.getControlEventName();
        String value = state.getControlEventValue();
        OID oid = new OID("com.arsdigita.forum.Post", (Object)new BigDecimal(value));
        ForumContext ctx = ForumContext.getContext(state);
        Post post = (Post)DomainObjectFactory.newInstance((OID)oid);
        if (ACTION_EDIT.equals(key)) {
            this.m_post.setSelectedObject(state, (DomainObject)post);
            this.m_threadMessagesPanel.makeEditFormVisible(state);
        } else if (ACTION_DELETE.equals(key)) {
            MessageThread thread = ctx.getMessageThread();
            ThreadedMessage root = thread.getRootMessage();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("message: " + post.getOID() + " root: " + root.getOID() + " thread: " + thread.getOID()));
            }
            if (ctx.getForum().isModerated()) {
                if (!ctx.canModerate()) {
                    Assert.isTrue((boolean)ctx.canAdminister(), (String)"can administer forums");
                    post.setStatus("suppressed");
                    post.save();
                } else {
                    if (post.equals(root)) {
                        Assert.isTrue((boolean)ctx.canDelete(post), (String)"can delete posts");
                        s_log.debug((Object)"Deleting entire thread");
                        post.delete();
                        Forum forum = ctx.getForum();
                        URL url = URL.there((HttpServletRequest)state.getRequest(), (Application)forum, null);
                        throw new RedirectSignal(url, true);
                    }
                    Assert.isTrue((boolean)ctx.canDelete(post), (String)"can delete posts");
                    s_log.debug((Object)"Deleting message");
                    post.delete();
                }
            } else {
                if (post.equals(root)) {
                    Assert.isTrue((boolean)ctx.canDelete(post), (String)"can delete posts");
                    s_log.debug((Object)"Deleting entire thread");
                    post.delete();
                    Forum forum = ctx.getForum();
                    URL url = URL.there((HttpServletRequest)state.getRequest(), (Application)forum, null);
                    throw new RedirectSignal(url, true);
                }
                Assert.isTrue((boolean)ctx.canDelete(post), (String)"can delete posts");
                s_log.debug((Object)"Deleting message");
                post.delete();
            }
        } else if (ACTION_REPLY.equals(key)) {
            this.m_post.setSelectedObject(state, (DomainObject)post);
            this.m_threadMessagesPanel.makeReplyFormVisible(state);
        } else if (ACTION_APPROVE.equals(key)) {
            post.setStatus("approved");
            post.save();
            post.sendNotifications(null);
        } else if (ACTION_REJECT.equals(key)) {
            this.m_post.setSelectedObject(state, (DomainObject)post);
            this.m_threadMessagesPanel.makeRejectFormVisible(state);
        }
        state.clearControlEvent();
        try {
            throw new RedirectSignal(state.stateAsURL(), true);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
    }

    private DomainCollection getMessages(PageState state) {
        ForumContext context = ForumContext.getContext(state);
        Party party = Kernel.getContext().getParty();
        Forum forum = context.getForum();
        BigDecimal rootID = context.getMessageThread().getRootMessage().getID();
        DataCollection messages = SessionManager.getSession().retrieve("com.arsdigita.forum.Post");
        if (forum.isNoticeboard()) {
            messages.addEqualsFilter("id", (Object)rootID);
            return new DomainCollection(messages);
        }
        FilterFactory ff = messages.getFilterFactory();
        messages.addFilter((Filter)ff.or().addFilter((Filter)ff.and().addFilter(ff.equals("root", null)).addFilter(ff.equals("id", (Object)rootID))).addFilter(ff.equals("root", (Object)rootID)));
        messages.addOrderWithNull("sortKey", (Object)"---", true);
        if (forum.isModerated() && !forum.canModerate(party)) {
            messages.addFilter((Filter)ff.or().addFilter(ff.equals("status", (Object)"approved")).addFilter(ff.equals("sender.id", (Object)(party == null ? null : party.getID()))));
        }
        return new DomainCollection(messages);
    }

    public void generateXML(PageState state, Element parent) {
        Element content = parent.newChildElement("forum:threadDisplay", "http://www.arsdigita.com/forum/1.0");
        this.exportAttributes(content);
        Forum forum = ForumContext.getContext(state).getForum();
        content.addAttribute("forumTitle", forum.getTitle());
        content.addAttribute("noticeboard", new Boolean(forum.isNoticeboard()).toString());
        DomainCollection messages = this.getMessages(state);
        Integer page = (Integer)state.getValue((ParameterModel)this.m_pageNumber);
        int pageNumber = page == null ? 1 : page;
        long objectCount = messages.size();
        int pageCount = (int)Math.ceil((double)objectCount / (double)this.m_pageSize);
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageNumber > pageCount) {
            pageNumber = pageCount == 0 ? 1 : pageCount;
        }
        long begin = (pageNumber - 1) * this.m_pageSize;
        int count = (int)Math.min((long)this.m_pageSize, objectCount - begin);
        long end = begin + (long)count;
        this.generatePaginatorXML(content, pageNumber, pageCount, this.m_pageSize, begin, end, objectCount);
        if (begin != 0L || end != 0L) {
            messages.setRange(new Integer((int)begin + 1), new Integer((int)end + 1));
        }
        while (messages.next()) {
            Post message = (Post)messages.getDomainObject();
            Element messageEl = content.newChildElement("forum:message", "http://www.arsdigita.com/forum/1.0");
            this.generateActionXML(state, messageEl, message, (long)messages.getPosition() == messages.size());
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(messageEl);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            xr.walk((DomainObject)message, DiscussionPostsList.class.getName());
        }
    }

    protected void generateActionXML(PageState state, Element parent, Post post, boolean isLast) {
        ForumContext ctx = ForumContext.getContext(state);
        Party party = Kernel.getContext().getParty();
        if (party == null) {
            party = Kernel.getPublicUser();
        }
        String status = post.getStatus();
        if (ctx.canModerate() && !status.equals("rejected") && !status.equals("suppressed")) {
            parent.addAttribute("rejectURL", this.makeURL(state, ACTION_REJECT, post));
        }
        if (ctx.canModerate()) {
            if (!post.getStatus().equals("approved")) {
                parent.addAttribute("approveURL", this.makeURL(state, ACTION_APPROVE, post));
            }
        }
        if (ctx.canAdminister() || post.canDelete(party) && isLast) {
            parent.addAttribute("deleteURL", this.makeURL(state, ACTION_DELETE, post));
        }
        if (post.canEdit(party)) {
            parent.addAttribute("editURL", this.makeURL(state, ACTION_EDIT, post));
        }
        PermissionDescriptor canRespond = new PermissionDescriptor(PrivilegeDescriptor.get((String)"forum_respond"), (ACSObject)Kernel.getContext().getResource(), party);
        if (!ctx.getForum().isNoticeboard() && PermissionService.checkPermission((PermissionDescriptor)canRespond)) {
            parent.addAttribute("replyURL", this.makeURL(state, ACTION_REPLY, post));
        }
    }

    protected String makeURL(PageState state, String action, Post post) {
        state.setControlEvent((Component)this, action, post.getID().toString());
        String url = null;
        try {
            url = state.stateAsURL();
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot create url", (Throwable)ex);
        }
        state.clearControlEvent();
        return url;
    }

    protected void generatePaginatorXML(Element parent, int pageNumber, int pageCount, int pageSize, long begin, long end, long objectCount) {
        Element paginator = parent.newChildElement("forum:paginator", "http://www.arsdigita.com/forum/1.0");
        URL here = Web.getContext().getRequestURL();
        ParameterMap params = new ParameterMap(here.getParameterMap());
        params.clearParameter("page");
        URL url = new URL(here.getScheme(), here.getServerName(), here.getServerPort(), here.getContextPath(), here.getServletPath(), here.getPathInfo(), params);
        paginator.addAttribute("param", "page");
        paginator.addAttribute("baseURL", XML.format((Object)url));
        paginator.addAttribute("pageNumber", XML.format((Object)new Integer(pageNumber)));
        paginator.addAttribute("pageCount", XML.format((Object)new Integer(pageCount)));
        paginator.addAttribute("pageSize", XML.format((Object)new Integer(pageSize)));
        paginator.addAttribute("objectBegin", XML.format((Object)new Long(begin + 1L)));
        paginator.addAttribute("objectEnd", XML.format((Object)new Long(end)));
        paginator.addAttribute("objectCount", XML.format((Object)new Long(objectCount)));
    }
}

