/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormCancelListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ThreadSubscription;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.DiscussionPostsList;
import com.arsdigita.forum.ui.PostForm;
import com.arsdigita.forum.ui.ReplyToPostForm;
import com.arsdigita.forum.ui.RootPostForm;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.forum.ui.admin.RejectionForm;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.messaging.MessageThread;
import org.apache.log4j.Logger;

public class DiscussionThreadSimpleView
extends ModalContainer
implements Constants {
    private static final Logger s_log = Logger.getLogger(DiscussionThreadSimpleView.class);
    private Container m_threadMessagesPanel;
    private PostForm m_rootForm;
    private PostForm m_replyForm;
    private Form m_rejectForm;
    private ACSObjectSelectionModel m_postModel = new ACSObjectSelectionModel("post");

    public DiscussionThreadSimpleView() {
        this.initComponents();
    }

    private void initComponents() {
        s_log.debug((Object)"creating edit post form");
        this.m_rootForm = new RootPostForm(this.m_postModel);
        s_log.debug((Object)"creating reply to post form");
        this.m_replyForm = new ReplyToPostForm(this.m_postModel);
        s_log.debug((Object)"creating reject form");
        this.m_rejectForm = new RejectionForm(this.m_postModel);
        this.addForm((Form)this.m_rootForm);
        this.addForm((Form)this.m_replyForm);
        this.addForm(this.m_rejectForm);
        this.m_threadMessagesPanel = new SimpleContainer();
        SimpleContainer linksPanel = new SimpleContainer("forum:threadOptions", "http://www.arsdigita.com/forum/1.0");
        Link returnLink = new Link((Component)new Label(Text.gz("forum.ui.thread.viewAll")), "index.jsp");
        returnLink.setClassAttr("actionLink");
        linksPanel.add((Component)returnLink);
        SimpleContainer subLinks = new SimpleContainer();
        subLinks.add(this.createThreadSubscribeLink());
        subLinks.add(this.createThreadUnsubscribeLink());
        linksPanel.add((Component)subLinks);
        this.m_threadMessagesPanel.add((Component)linksPanel);
        this.m_threadMessagesPanel.add((Component)new DiscussionPostsList(this.m_postModel, this));
        this.add((Component)this.m_threadMessagesPanel);
        this.setDefaultComponent((Component)this.m_threadMessagesPanel);
    }

    public void makeListViewVisible(PageState state) {
        this.setVisibleComponent(state, (Component)this.m_threadMessagesPanel);
    }

    public void makeEditFormVisible(PageState state) {
        s_log.debug((Object)"making edit form visible");
        Post post = (Post)this.m_postModel.getSelectedObject(state);
        if (post.getRoot() == null) {
            this.m_rootForm.setContext(state, "edit");
            this.setVisibleComponent(state, (Component)this.m_rootForm);
        } else {
            this.m_replyForm.setContext(state, "edit");
            this.setVisibleComponent(state, (Component)this.m_replyForm);
        }
    }

    public void makeReplyFormVisible(PageState state) {
        s_log.debug((Object)"making reply form visible");
        this.m_replyForm.setContext(state, "reply");
        this.setVisibleComponent(state, (Component)this.m_replyForm);
    }

    public void makeRejectFormVisible(PageState state) {
        this.setVisibleComponent(state, (Component)this.m_rejectForm);
    }

    private final void addForm(Form form) {
        this.add((Component)form);
        form.addCompletionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                s_log.debug((Object)"FORM ACTION COMPLETED");
                PageState ps = e.getPageState();
                DiscussionThreadSimpleView.this.makeListViewVisible(ps);
            }
        });
        form.addCancelListener(new FormCancelListener(){

            public void cancel(FormSectionEvent e) {
                s_log.debug((Object)"fire cancel listener");
                PageState ps = e.getPageState();
                DiscussionThreadSimpleView.this.makeListViewVisible(ps);
            }
        });
    }

    private Component createThreadSubscribeLink() {
        ActionLink subscribeLink = new ActionLink((Component)new Label(Text.gz("forum.ui.thread.subscribe"))){

            public boolean isVisible(PageState s) {
                Party party = Kernel.getContext().getParty();
                if (party != null) {
                    ThreadSubscription sub = ThreadSubscription.getThreadSubscription(DiscussionThreadSimpleView.this.getCurrentMessage(s));
                    return !sub.isSubscribed(party);
                }
                return false;
            }
        };
        subscribeLink.setClassAttr("actionLink");
        subscribeLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                Party party = Kernel.getContext().getParty();
                ThreadSubscription sub = ThreadSubscription.getThreadSubscription(DiscussionThreadSimpleView.this.getCurrentMessage(s));
                if (!sub.isSubscribed(party)) {
                    sub.subscribe(party);
                }
                sub.save();
            }
        });
        return subscribeLink;
    }

    private Component createThreadUnsubscribeLink() {
        ActionLink unsubscribeLink = new ActionLink((Component)new Label(Text.gz("forum.ui.thread.unsubscribe"))){

            public boolean isVisible(PageState s) {
                Party party = Kernel.getContext().getParty();
                if (party != null) {
                    ThreadSubscription sub = ThreadSubscription.getThreadSubscription(DiscussionThreadSimpleView.this.getCurrentMessage(s));
                    return sub.isSubscribed(party);
                }
                return false;
            }
        };
        unsubscribeLink.setClassAttr("actionLink");
        unsubscribeLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                Party party = Kernel.getContext().getParty();
                ThreadSubscription sub = ThreadSubscription.getThreadSubscription(DiscussionThreadSimpleView.this.getCurrentMessage(s));
                if (sub.isSubscribed(party)) {
                    sub.unsubscribe(party);
                }
                sub.save();
            }
        });
        return unsubscribeLink;
    }

    private final ACSObjectSelectionModel getPostModel() {
        return this.m_postModel;
    }

    private MessageThread getCurrentMessage(PageState state) {
        return ForumContext.getContext(state).getMessageThread();
    }
}

