/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ForumAlertsView;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.forum.ui.ThreadsPanel;
import com.arsdigita.forum.ui.TopicsPanel;
import com.arsdigita.forum.ui.admin.ModerationView;
import com.arsdigita.forum.ui.admin.PermissionsView;
import com.arsdigita.forum.ui.admin.SetupView;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ForumUserCompactView
extends ModalContainer
implements Constants {
    private static Logger s_log = Logger.getLogger(ForumUserCompactView.class);
    public static final String MODE_THREADS = "threads";
    public static final String MODE_TOPICS = "topics";
    public static final String MODE_ALERTS = "alerts";
    public static final String MODE_MODERATION = "moderation";
    public static final String MODE_PERMISSIONS = "permissions";
    public static final String MODE_SETUP = "setup";
    private StringParameter m_mode = new StringParameter("mode");
    private ThreadsPanel m_threadsView = new ThreadsPanel();
    private TopicsPanel m_topicsView = new TopicsPanel();
    private ForumAlertsView m_alertsView = new ForumAlertsView();
    private ModerationView m_moderationView = new ModerationView();
    private SetupView m_setupView = new SetupView();
    private PermissionsView m_permissionsView = new PermissionsView();

    public ForumUserCompactView() {
        super("forum:forum", "http://www.arsdigita.com/forum/1.0");
        this.add((Component)this.m_threadsView);
        this.add((Component)this.m_topicsView);
        this.add((Component)this.m_alertsView);
        this.add((Component)this.m_moderationView);
        this.add((Component)this.m_setupView);
        this.add((Component)this.m_permissionsView);
        this.setDefaultComponent((Component)this.m_threadsView);
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_mode);
    }

    public void respond(PageState state) throws ServletException {
        super.respond(state);
        Party party = Kernel.getContext().getParty();
        Forum forum = ForumContext.getContext(state).getForum();
        String mode = state.getControlEventValue();
        state.setValue((ParameterModel)this.m_mode, (Object)mode);
        this.setVisible(state, party, forum, mode);
    }

    protected void setVisible(PageState state, Party party, Forum forum, String mode) {
        PermissionDescriptor forumAdmin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)forum, party);
        if (MODE_TOPICS.equals(mode)) {
            if (Forum.getConfig().topicCreationByAdminOnly()) {
                if (party == null) {
                    UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
                }
                PermissionService.assertPermission((PermissionDescriptor)forumAdmin);
            }
            this.setVisibleComponent(state, (Component)this.m_topicsView);
        } else if (MODE_ALERTS.equals(mode)) {
            if (party == null) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
            this.setVisibleComponent(state, (Component)this.m_alertsView);
        } else if (MODE_MODERATION.equals(mode)) {
            if (party == null) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
            PermissionService.assertPermission((PermissionDescriptor)forumAdmin);
            this.setVisibleComponent(state, (Component)this.m_moderationView);
        } else if (MODE_PERMISSIONS.equals(mode)) {
            if (party == null) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
            PermissionService.assertPermission((PermissionDescriptor)forumAdmin);
            this.setVisibleComponent(state, (Component)this.m_permissionsView);
        } else if (MODE_SETUP.equals(mode)) {
            if (party == null) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
            PermissionService.assertPermission((PermissionDescriptor)forumAdmin);
            this.setVisibleComponent(state, (Component)this.m_setupView);
        } else if (MODE_THREADS.equals(mode)) {
            if (party == null) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
            this.setVisibleComponent(state, (Component)this.m_threadsView);
        }
    }

    public void generateXML(PageState state, Element parent) {
        Element content = this.generateParent(parent);
        Forum forum = ForumContext.getContext(state).getForum();
        content.addAttribute("title", forum.getTitle());
        content.addAttribute("noticeboard", new Boolean(forum.isNoticeboard()).toString());
        Party party = Kernel.getContext().getParty();
        if (party == null) {
            party = Kernel.getPublicUser();
        }
        this.generateModes(state, content, party, forum);
        this.generateChildrenXML(state, content);
    }

    protected void generateModes(PageState state, Element content, Party party, Forum forum) {
        PermissionDescriptor adminPermission = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)forum, party);
        PermissionDescriptor readPermission = new PermissionDescriptor(PrivilegeDescriptor.get((String)"forum_read"), (ACSObject)forum, party);
        if (forum.isPublic()) {
            this.generateModeXML(state, content, MODE_THREADS, Text.gz("forum.ui.modeThreads"));
        } else if (PermissionService.checkPermission((PermissionDescriptor)readPermission)) {
            this.generateModeXML(state, content, MODE_THREADS, Text.gz("forum.ui.modeThreads"));
        }
        if (!Forum.getConfig().topicCreationByAdminOnly()) {
            this.generateModeXML(state, content, MODE_TOPICS, Text.gz("forum.ui.modeTopics"));
        }
        this.generateModeXML(state, content, MODE_ALERTS, Text.gz("forum.ui.modeAlerts"));
        if (PermissionService.checkPermission((PermissionDescriptor)adminPermission)) {
            if (Forum.getConfig().showNewTabs()) {
                this.generateModeXML(state, content, MODE_SETUP, Text.gz("forum.ui.modeSetup"));
                this.generateModeXML(state, content, MODE_PERMISSIONS, Text.gz("forum.ui.modePermissions"));
            } else {
                this.generateModeXML(state, content, MODE_MODERATION, Text.gz("forum.ui.modeAlerts"));
            }
            if (Forum.getConfig().topicCreationByAdminOnly()) {
                this.generateModeXML(state, content, MODE_TOPICS, Text.gz("forum.ui.modeTopics"));
            }
        }
    }

    protected void generateModeXML(PageState state, Element parent, String mode) {
        this.generateModeXML(state, parent, mode, null);
    }

    protected void generateModeXML(PageState state, Element parent, String mode, GlobalizedMessage label) {
        String current = (String)state.getValue((ParameterModel)this.m_mode);
        if (current == null) {
            current = MODE_THREADS;
        }
        Element content = parent.newChildElement("forum:forumMode", "http://www.arsdigita.com/forum/1.0");
        state.setControlEvent((Component)this, "mode", mode);
        content.addAttribute("mode", mode);
        try {
            content.addAttribute("url", state.stateAsURL());
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot create url", (Throwable)ex);
        }
        if (label == null) {
            content.addAttribute("label", "UNAVAILABLE");
        } else {
            content.addAttribute("label", (String)label.localize());
        }
        content.addAttribute("selected", current.equals(mode) ? "1" : "0");
        state.clearControlEvent();
    }
}

