/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Wizard;
import com.arsdigita.bebop.event.FormCancelListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ThreadSubscription;
import com.arsdigita.forum.ui.AttachedFilesStep;
import com.arsdigita.forum.ui.ConfirmStep;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ImagesStep;
import com.arsdigita.forum.ui.PostTextStep;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.xml.Element;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class PostForm
extends Wizard
implements Constants {
    private static final Logger s_log = Logger.getLogger(PostForm.class);
    private PostTextStep m_textStep;
    private ImagesStep m_attachImages;
    private AttachedFilesStep m_attachFiles;
    private ConfirmStep m_confirm;
    private ACSObjectSelectionModel m_post;
    private StringParameter m_context = new StringParameter("context");
    public static final String NEW_CONTEXT = "new";
    public static final String REPLY_CONTEXT = "reply";
    public static final String EDIT_CONTEXT = "edit";

    public PostForm(String name) {
        this(name, null);
    }

    public PostForm(String name, ACSObjectSelectionModel post) {
        super(name, (Container)new SimpleContainer(), Forum.getConfig().quickFinishAllowed(), true);
        this.setEncType("multipart/form-data");
        this.setMethod("post");
        this.m_post = post;
    }

    public void setContext(PageState state, String context) {
        state.setValue((ParameterModel)this.m_context, (Object)context);
    }

    public String getContext(PageState state) {
        return (String)state.getValue((ParameterModel)this.m_context);
    }

    protected void setupComponent() {
        this.m_textStep = this.getTextStep(this.m_post);
        this.add((Container)this.m_textStep);
        this.m_attachImages = new ImagesStep(this.m_post, this);
        this.add((Container)this.m_attachImages);
        this.m_attachFiles = new AttachedFilesStep(this.m_post, this);
        this.add((Container)this.m_attachFiles);
        this.m_confirm = new ConfirmStep(this.m_post, this);
        this.add((Container)this.m_confirm);
        this.addInitListener(new PostInitListener());
        this.addCancelListener(new PostCancelListener());
        this.addSubmissionListener(new PostSubmissionListener());
        this.addProcessListener(new PostProcessListener());
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_context);
    }

    protected abstract PostTextStep getTextStep(ACSObjectSelectionModel var1);

    protected abstract Post getPost(PageState var1);

    public Post getSelectedPost(PageState state) {
        if (this.m_post == null) {
            return null;
        }
        return (Post)this.m_post.getSelectedObject(state);
    }

    protected void generatePostXML(PageState state, Element content) {
        this.m_textStep.generatePostXML(state, content);
        this.m_attachFiles.generatePostXML(state, content);
        this.m_attachImages.generatePostXML(state, content);
    }

    private void clearParameters(PageState state) {
        state.setValue((ParameterModel)this.m_context, null);
        this.m_attachImages.clearParameters(state);
        this.m_attachFiles.clearParameters(state);
    }

    private class PostProcessListener
    implements FormProcessListener {
        private PostProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"process called on Parent Form");
            PageState state = e.getPageState();
            Post post = PostForm.this.getPost(state);
            post.setStatus(state);
            PostForm.this.m_textStep.setText(post, state);
            post.save();
            PostForm.this.m_attachFiles.attachFiles(post, state);
            PostForm.this.m_attachImages.attachImages(post, state);
            if (PostForm.this.getContext(state).equals(PostForm.NEW_CONTEXT)) {
                User threadStarter;
                s_log.debug((Object)"new thread - create subscription");
                ThreadSubscription sub = post.createThreadSubscription();
                ForumContext ctx = ForumContext.getContext(state);
                Forum forum = ctx.getForum();
                if (forum.autoSubscribeThreadStarter() && (threadStarter = (User)Kernel.getContext().getParty()) != null && !threadStarter.equals((Object)Kernel.getPublicUser())) {
                    s_log.debug((Object)"auto subscribing current user");
                    sub.subscribe((Party)threadStarter);
                }
            }
            post.sendNotifications((String)state.getValue((ParameterModel)PostForm.this.m_context));
            post.sendModeratorAlerts();
            PostForm.this.clearParameters(state);
            PostForm.this.fireCompletionEvent(state);
        }
    }

    private class PostCancelListener
    implements FormCancelListener {
        private PostCancelListener() {
        }

        public void cancel(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            PostForm.this.clearParameters(state);
            PostForm.this.fireCompletionEvent(state);
        }
    }

    private class PostSubmissionListener
    implements FormSubmissionListener {
        private PostSubmissionListener() {
        }

        public void submitted(FormSectionEvent e) {
            s_log.debug((Object)"page submitted");
            PageState state = e.getPageState();
            ForumContext ctx = ForumContext.getContext(state);
            Forum forum = ctx.getForum();
            if (!forum.allowImageUploads()) {
                PostForm.this.hideStep(1, state);
            }
            if (!forum.allowFileAttachments()) {
                PostForm.this.hideStep(2, state);
            }
        }
    }

    private class PostInitListener
    implements FormInitListener {
        private PostInitListener() {
        }

        public void init(FormSectionEvent e) {
            s_log.debug((Object)"init called on parent form");
            PageState state = e.getPageState();
            if (Kernel.getContext().getParty() == null && !ForumContext.getContext(state).getForum().anonymousPostsAllowed()) {
                UserContext.redirectToLoginPage((HttpServletRequest)state.getRequest());
            }
        }
    }
}

