/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.Bebop;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormStep;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.DHTMLEditor;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.PostForm;
import com.arsdigita.forum.ui.Text;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.toolbox.ui.TextTypeWidget;
import com.arsdigita.xml.Element;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class PostTextStep
extends FormStep
implements Constants {
    private static Logger s_log = Logger.getLogger(PostTextStep.class);
    private PostForm m_container;
    private static final String FCK_FORUM_CONFIG = "/assets/fckeditor/config/fckconfig_forum.js";
    private TextField m_subject;
    private TextArea m_body;
    private TextTypeWidget m_bodyType;
    private ACSObjectSelectionModel m_post;

    public PostTextStep(ACSObjectSelectionModel post, PostForm container) {
        super("postText", (Container)new SimpleContainer("forum:postForm", "http://www.arsdigita.com/forum/1.0"));
        this.m_container = container;
        this.m_post = post;
        this.m_subject = new TextField((ParameterModel)new StringParameter("subject"));
        this.m_subject.addValidationListener((ParameterListener)new NotEmptyValidationListener(Text.gz("forum.ui.validation.subject_null")));
        this.m_subject.setMaxLength(250);
        this.m_subject.setSize(60);
        this.add((Component)this.m_subject);
        if (Forum.getConfig().useWysiwygEditor()) {
            this.m_body = new DHTMLEditor("message");
            this.m_body.setRows(8);
            this.m_body.setCols(60);
            this.m_body.setMetaDataAttribute("width", "450");
            this.m_body.setMetaDataAttribute("height", "300");
            this.m_body.setWrap(2);
            if (Bebop.getConfig().getDHTMLEditor().equals("bebop:fckeditor")) {
                ((DHTMLEditor)this.m_body).setConfig(new DHTMLEditor.Config("forum", FCK_FORUM_CONFIG));
            } else {
                ((DHTMLEditor)this.m_body).hideButton("insertlink");
            }
        } else {
            this.m_body = new TextArea((ParameterModel)new StringParameter("message"), 8, 60, 2);
        }
        this.m_body.addValidationListener((ParameterListener)new NotEmptyValidationListener(Text.gz("forum.ui.validation.body_null")));
        this.add((Component)this.m_body);
        this.m_bodyType = new TextTypeWidget((ParameterModel)new StringParameter("bodyType"), "text/plain");
        this.add((Component)this.m_bodyType);
        this.addInitListener(new InitTextStepListener());
    }

    protected void setSubject(PageState state, String text) {
        this.m_subject.setValue(state, (Object)text);
    }

    protected void setBody(PageState state, String body, String bodyType) {
        this.m_body.setValue(state, (Object)body);
        this.m_bodyType.setValue(state, (Object)bodyType);
    }

    protected void initWidgets(PageState state, Post post) {
        StringBuffer body = new StringBuffer();
        if (this.m_container.getContext(state).equals("edit")) {
            if (Forum.getConfig().useWysiwygEditor()) {
                body.append("<p>\n<i>\n");
                body.append("Edited on " + DateFormat.getDateInstance(3).format(new Date()) + " by " + ((User)Kernel.getContext().getParty()).getName());
                body.append("\n</i>\n</p>\n\n<br/>\n\n");
            } else {
                body.append("\n");
                body.append("Edited on " + DateFormat.getDateInstance(3).format(new Date()) + " by " + ((User)Kernel.getContext().getParty()).getName());
                body.append("\n\n");
            }
        }
        body.append(post.getBody());
        this.setSubject(state, post.getSubject());
        this.setBody(state, body.toString(), post.getBodyType());
    }

    public void setText(Post post, PageState state) {
        post.setSubject((String)this.m_subject.getValue(state));
        post.setBody((String)this.m_body.getValue(state), (String)this.m_bodyType.getValue(state));
    }

    public void generatePostXML(PageState state, Element content) {
        Element subject = content.newChildElement("subject");
        subject.setText((String)this.m_subject.getValue(state));
        Element body = content.newChildElement("body");
        body.setText((String)this.m_body.getValue(state));
    }

    private class InitTextStepListener
    implements FormInitListener {
        private InitTextStepListener() {
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)"Init called on Text Step");
            PageState state = e.getPageState();
            if (Forum.getConfig().useWysiwygEditor()) {
                PostTextStep.this.m_bodyType.setValue(state, (Object)"text/html");
                PostTextStep.this.m_bodyType.setVisible(state, false);
            }
            if (PostTextStep.this.m_post != null) {
                Post post = (Post)PostTextStep.this.m_post.getSelectedObject(state);
                PostTextStep.this.initWidgets(state, post);
            }
        }
    }
}

