/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TopicsList
extends SimpleComponent
implements Constants {
    private static final Logger logger = Logger.getLogger(TopicsList.class);
    private static final Set s_catProps;

    public void generateXML(PageState state, Element parent) {
        Element content = parent.newChildElement("forum:topicList", "http://www.arsdigita.com/forum/1.0");
        this.exportAttributes(content);
        URL url = URL.request((HttpServletRequest)state.getRequest(), null);
        content.addAttribute("baseURL", url.toString());
        content.addAttribute("param", "topic");
        Forum forum = ForumContext.getContext(state).getForum();
        DataQuery categories = forum.getCategories();
        this.generateQueryXML(content, categories);
        DataQuery unCategory = forum.getUnCategory();
        while (unCategory.next()) {
            Element noTopic = content.newChildElement("forum:noTopicSummary", "http://www.arsdigita.com/forum/1.0");
            Element id = noTopic.newChildElement("id");
            id.setText(XML.format((Object)TOPIC_NONE));
            Element latestPost = noTopic.newChildElement("latestPost");
            latestPost.setText(XML.format((Object)unCategory.get("latestPost")));
            Element numThreads = noTopic.newChildElement("numThreads");
            numThreads.setText(XML.format((Object)unCategory.get("numThreads")));
        }
    }

    public void generateQueryXML(Element parent, DataQuery query) {
        while (query.next()) {
            Element content = parent.newChildElement("forum:topicSummary", "http://www.arsdigita.com/forum/1.0");
            for (String key : s_catProps) {
                Object value = query.get(key);
                if (value == null) continue;
                Element attr = content.newChildElement(key);
                attr.setText(XML.format((Object)value));
            }
        }
    }

    static {
        logger.debug((Object)"Static initalizer starting...");
        s_catProps = new HashSet();
        s_catProps.add("id");
        s_catProps.add("name");
        s_catProps.add("numThreads");
        s_catProps.add("latestPost");
        logger.debug((Object)"Static initalizer finished.");
    }
}

