/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ui.Text;
import org.apache.log4j.Logger;

public class NoticeboardFormSection
extends FormSection {
    private static final Logger s_log = Logger.getLogger(NoticeboardFormSection.class);
    private Label m_statusOn;
    private Label m_statusOff;
    private Submit m_switchOn;
    private Submit m_switchOff;
    private Submit m_changeExpiry;
    private Label m_expiryLabel;
    private TextField m_expiry;

    public NoticeboardFormSection() {
        super((Container)new ColumnPanel(3, true));
        this.addWidgets();
        this.addProcessListener(new ModFormProcessListener());
        this.addInitListener(new ModFormInitListener());
    }

    public void addWidgets() {
        this.add((Component)new Label(Text.gz("forum.ui.noticeboard.label")));
        this.m_statusOn = new Label(Text.gz("forum.ui.noticeboard.status.on"));
        this.m_statusOff = new Label(Text.gz("forum.ui.noticeboard.status.off"));
        this.add((Component)this.m_statusOn);
        this.add((Component)this.m_statusOff);
        this.m_switchOn = new Submit(Text.gz("forum.ui.noticeboard.switch.on"));
        this.m_switchOff = new Submit(Text.gz("forum.ui.noticeboard.switch.off"));
        this.add((Component)this.m_switchOn);
        this.add((Component)this.m_switchOff);
        this.m_expiryLabel = new Label(Text.gz("forum.ui.noticeboard.expiry_after"));
        this.m_expiry = new TextField((ParameterModel)new IntegerParameter("expiry"));
        this.m_changeExpiry = new Submit(Text.gz("forum.ui.noticeboard.change_expiry"));
        this.add((Component)this.m_expiryLabel);
        this.add((Component)this.m_expiry);
        this.add((Component)this.m_changeExpiry);
    }

    private void calculateVisibility(PageState state) {
        Forum forum = ForumContext.getContext(state).getForum();
        boolean noticeboard = forum.isNoticeboard();
        this.m_statusOn.setVisible(state, noticeboard);
        this.m_statusOff.setVisible(state, !noticeboard);
        this.m_switchOn.setVisible(state, !noticeboard);
        this.m_switchOff.setVisible(state, noticeboard);
        this.m_expiry.setVisible(state, noticeboard);
        this.m_expiryLabel.setVisible(state, noticeboard);
        this.m_changeExpiry.setVisible(state, noticeboard);
    }

    private class ModFormInitListener
    implements FormInitListener {
        private ModFormInitListener() {
        }

        public void init(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            NoticeboardFormSection.this.calculateVisibility(state);
            Forum forum = ForumContext.getContext(state).getForum();
            NoticeboardFormSection.this.m_expiry.setValue(state, (Object)new Integer(forum.getExpireAfter()));
        }
    }

    private class ModFormProcessListener
    implements FormProcessListener {
        private ModFormProcessListener() {
        }

        public void process(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            Forum forum = ForumContext.getContext(state).getForum();
            if (NoticeboardFormSection.this.m_switchOn.isSelected(state)) {
                s_log.debug((Object)"Switch on pressed");
                forum.setNoticeboard(true);
            } else if (NoticeboardFormSection.this.m_switchOff.isSelected(state)) {
                s_log.debug((Object)"Switch off pressed");
                forum.setNoticeboard(false);
            } else if (NoticeboardFormSection.this.m_changeExpiry.isSelected(state)) {
                forum.setExpireAfter((Integer)NoticeboardFormSection.this.m_expiry.getValue(state));
            } else {
                s_log.debug((Object)"Something else pressed");
            }
            NoticeboardFormSection.this.calculateVisibility(state);
        }
    }
}

