/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.upgrade;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumSubscription;
import com.arsdigita.forum.ThreadCollection;
import com.arsdigita.forum.ThreadSubscription;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.cmd.Program;
import com.arsdigita.web.ApplicationType;
import org.apache.commons.cli.CommandLine;
import org.apache.log4j.Logger;

public class CreateContainerGroups
extends Program {
    private static Logger s_log = Logger.getLogger(CreateContainerGroups.class);

    public CreateContainerGroups() {
        super("CreateGroups", "1.0.0", "");
    }

    public void doRun(CommandLine cmdLine) {
        try {
            Session session = SessionManager.getSession();
            TransactionContext tc = session.getTransactionContext();
            DataCollection types = session.retrieve("com.arsdigita.web.ApplicationType");
            types.addEqualsFilter("objectType", (Object)"com.arsdigita.forum.Forum");
            if (types.next()) {
                ApplicationType forumApps = (ApplicationType)DomainObjectFactory.newInstance((DataObject)types.getDataObject());
                if (forumApps.getGroup() == null) {
                    forumApps.createGroup();
                    types.close();
                    s_log.debug((Object)"created app type group");
                    System.out.println("created app type group");
                } else {
                    s_log.debug((Object)"Forum app type group exists");
                    System.out.println("Forum app type group exists");
                }
            }
            DataCollection existingForums = session.retrieve("com.arsdigita.forum.Forum");
            while (existingForums.next()) {
                Forum forum = (Forum)DomainObjectFactory.newInstance((DataObject)existingForums.getDataObject());
                s_log.debug((Object)("****************" + forum.getTitle()));
                System.out.println("****************" + forum.getTitle());
                Group existingGroup = forum.getGroup();
                if (existingGroup == null) {
                    tc.beginTxn();
                    forum.createGroup();
                    Group container = forum.getGroup();
                    forum.getAdminGroup().setName(forum.getTitle() + " Administrators");
                    forum.getModerationGroup().setName(forum.getTitle() + " Moderators");
                    forum.getThreadCreateGroup().setName(forum.getTitle() + " Thread Creators");
                    forum.getThreadResponderGroup().setName(forum.getTitle() + " Thread Responders");
                    forum.getReadGroup().setName(forum.getTitle() + " Readers");
                    container.addSubgroup(forum.getAdminGroup());
                    container.addSubgroup(forum.getModerationGroup());
                    container.addSubgroup(forum.getThreadCreateGroup());
                    container.addSubgroup(forum.getThreadResponderGroup());
                    container.addSubgroup(forum.getReadGroup());
                    DataCollection subscriptions = forum.getSubscriptions();
                    while (subscriptions.next()) {
                        ForumSubscription forumSubscription = (ForumSubscription)DomainObjectFactory.newInstance((DataObject)subscriptions.getDataObject());
                        Group subscriptionGroup = forumSubscription.getGroup();
                        subscriptionGroup.setName(forumSubscription.getSubscriptionGroupName());
                        container.addSubgroup(subscriptionGroup);
                    }
                    GroupCollection subgroups = container.getSubgroups();
                    subgroups.addEqualsFilter("name", (Object)"Thread Subscription Groups");
                    if (subgroups.size() == 0L) {
                        Group threadSubscriptions = new Group();
                        threadSubscriptions.setName("Thread Subscription Groups");
                        container.addSubgroup(threadSubscriptions);
                        ThreadCollection threads = forum.getThreads();
                        while (threads.next()) {
                            MessageThread thread = threads.getMessageThread();
                            ThreadSubscription subscription = ThreadSubscription.getThreadSubscription(thread);
                            if (subscription == null) continue;
                            Group group = subscription.getGroup();
                            group.setName(subscription.getSubscriptionGroupName(forum));
                            threadSubscriptions.addSubgroup(group);
                        }
                    }
                    tc.commitTxn();
                    continue;
                }
                System.out.println("group exists for " + forum.getTitle() + " - skipping to next forum");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            s_log.error((Object)"error occured", e);
        }
    }

    public static final void main(String[] args) {
        new CreateContainerGroups().run(args);
    }
}

