/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.forum.upgrade;

import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.forum.Forum;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.portal.PortletType;
import com.arsdigita.util.cmd.Program;
import org.apache.commons.cli.CommandLine;

public class CreateGroupsAndPortletType
extends Program {
    public CreateGroupsAndPortletType() {
        super("CreateGroups", "1.0.0", "");
    }

    public void doRun(CommandLine cmdLine) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Session session = SessionManager.getSession();
                TransactionContext tc = session.getTransactionContext();
                tc.beginTxn();
                DataCollection existingForums = session.retrieve("com.arsdigita.forum.Forum");
                while (existingForums.next()) {
                    Forum forum = (Forum)DomainObjectFactory.newInstance((DataObject)existingForums.getDataObject());
                    Group admin = new Group();
                    admin.setName(forum.getTitle() + " Administrators");
                    forum.setAdminGroup(admin);
                    Group threadCreators = new Group();
                    threadCreators.setName(forum.getTitle() + " Thread Creators");
                    forum.setThreadCreatorGroup(threadCreators);
                    threadCreators.addMember(Kernel.getPublicUser());
                    Group threadResponders = new Group();
                    threadResponders.setName(forum.getTitle() + " Thread Responders");
                    forum.setThreadResponderGroup(threadResponders);
                    Group threadReaders = new Group();
                    threadReaders.setName(forum.getTitle() + " Readers");
                    forum.setReaderGroup(threadReaders);
                }
                PortletType type = PortletType.createPortletType((String)"My Forums", (String)"wide", (String)"com.arsdigita.forum.MyForumsPortlet");
                type.setDescription("Lists forums that user has access to, with last posting date");
                tc.commitTxn();
            }
        }.run();
    }

    public static void main(String[] args) {
        new CreateGroupsAndPortletType().run(args);
    }
}

