/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.portal.PortletType;
import com.arsdigita.rssfeed.Feed;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.URL;
import org.apache.log4j.Logger;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Loader.this.setupChannelControlCenter();
                Loader.this.setupLocalFeeds();
                Loader.this.loadWorkspaceDirectoryPortlet();
            }
        }.run();
    }

    public void setupChannelControlCenter() {
        ApplicationType type = new ApplicationType("RSS Feed", "com.arsdigita.rssfeed.RSSFeed");
        type.setSingleton(true);
        type.setDescription("Provides RSS feed service");
        if (!Application.isInstalled((String)"com.arsdigita.rssfeed.RSSFeed", (String)"/channels/")) {
            Application app = Application.createApplication((ApplicationType)type, (String)"channels", (String)"RSS Service", null);
            app.setDescription("RSS feed channels");
            app.save();
        }
    }

    public void setupLocalFeeds() {
        Feed feed;
        URL external = URL.there((String)"/channels/rss/external.rss", null);
        try {
            Feed feed2 = Feed.retrieve(external.getURL());
        }
        catch (DataObjectNotFoundException ex) {
            feed = Feed.create(external.getURL(), "External feeds", "External rss content feeds", true);
            feed.save();
        }
        URL index = URL.there((String)"/channels/rss/index.rss", null);
        try {
            feed = Feed.retrieve(index.getURL());
        }
        catch (DataObjectNotFoundException ex) {
            Feed feed3 = Feed.create(index.getURL(), "Local content feeds", "Local CMS content feeds", true);
            feed3.save();
        }
    }

    private void loadWorkspaceDirectoryPortlet() {
        PortletType type = PortletType.createPortletType((String)"Workspace Directory", (String)"wide", (String)"com.arsdigita.london.portal.portlet.WorkspaceDirectoryPortlet");
        type.setDescription("Displays a list of workspaces");
    }
}

