/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.StringParameter;
import org.apache.log4j.Logger;

public final class RSSFeedConfig
extends AbstractConfig {
    private static final Logger s_log = Logger.getLogger(RSSFeedConfig.class);
    private static RSSFeedConfig s_conf;
    private final Parameter m_categoryKey = new RSSCategoryKeyParameter("com.arsdigita.rssfeed.categoryKey", 1, "RSS");
    private final Parameter m_processingInstruction_xslt = new StringParameter("com.arsdigita.rssfeed.processingInstruction_xslt", 0, null);

    public static synchronized RSSFeedConfig getConfig() {
        if (s_conf == null) {
            s_conf = new RSSFeedConfig();
            s_conf.load();
        }
        return s_conf;
    }

    public RSSFeedConfig() {
        this.register(this.m_categoryKey);
        this.register(this.m_processingInstruction_xslt);
        this.loadInfo();
    }

    public String getCategoryKey() {
        return (String)this.get(this.m_categoryKey);
    }

    public String getPIxslt() {
        return (String)this.get(this.m_processingInstruction_xslt);
    }

    private static class RSSCategoryKeyParameter
    extends StringParameter {
        RSSCategoryKeyParameter(String name, int multiplicity, Object defaalt) {
            super(name, multiplicity, defaalt);
        }

        public void doValidate(Object value, ErrorList errors) {
            if (value != null) {
                String key = (String)value;
                for (int i = 0; i < key.length(); ++i) {
                    char j = key.charAt(i);
                    if (!Character.isWhitespace(j)) continue;
                    errors.add(new ParameterError((Parameter)this, "The value of " + this.getName() + " must not " + " contain any white space"));
                    break;
                }
            } else {
                errors.add(new ParameterError((Parameter)this, "The value of " + this.getName() + " must not be null."));
            }
        }
    }
}

