/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed;

import com.arsdigita.web.Application;
import com.arsdigita.web.DefaultApplicationFileResolver;
import com.arsdigita.web.Web;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class RSSFileResolver
extends DefaultApplicationFileResolver {
    private static final Logger s_log = Logger.getLogger(RSSFileResolver.class);

    public RequestDispatcher resolve(String templatePath, HttpServletRequest sreq, HttpServletResponse sresp, Application app) {
        String[] webapps = new String[]{app.getContextPath(), "ROOT"};
        String pathInfo = sreq.getPathInfo();
        if (pathInfo.endsWith(".rss") || pathInfo.endsWith(".xml")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 3) + "jsp";
            String node = app.getPath();
            do {
                RequestDispatcher rd;
                String path;
                if ((path = templatePath + node + pathInfo).endsWith("/")) {
                    path = path + "index.jsp";
                }
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Trying resource " + path));
                }
                if ((rd = Web.findResourceDispatcher((String[])webapps, (String)path)) != null) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Got dispatcher " + rd));
                    }
                    return rd;
                }
                if ("".equals(node)) {
                    node = null;
                    continue;
                }
                int index = node.lastIndexOf("/", node.length() - 2);
                node = node.substring(0, index);
            } while (node != null);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"No dispatcher found");
            }
            return null;
        }
        return super.resolve(templatePath, sreq, sresp, app);
    }
}

