/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed;

import com.arsdigita.rssfeed.RSSChannel;
import com.arsdigita.rssfeed.RSSImage;
import com.arsdigita.rssfeed.RSSItem;
import com.arsdigita.rssfeed.RSSItemCollection;
import com.arsdigita.util.UncheckedWrapperException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;

public class RSSRenderer {
    public static final Namespace s_rdfNS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    public static final Namespace s_rssNS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");

    public static Element generateJDOM(RSSChannel channel) {
        Element linkEl;
        Element titleEl;
        Element seqEl;
        Element rdfEl = new Element("RDF", "rdf", s_rdfNS.getURI());
        rdfEl.addNamespaceDeclaration(s_rssNS);
        Element channelEl = new Element("channel", s_rssNS);
        channelEl.setAttribute("about", channel.getLink(), s_rdfNS);
        rdfEl.addContent(channelEl);
        Element channelTitleEl = new Element("title", s_rssNS);
        channelTitleEl.setText(channel.getTitle());
        channelEl.addContent(channelTitleEl);
        Element channelLinkEl = new Element("link", s_rssNS);
        channelLinkEl.setText(channel.getLink());
        channelEl.addContent(channelLinkEl);
        Element channelDescriptionEl = new Element("description", s_rssNS);
        channelDescriptionEl.setText(channel.getDescription());
        channelEl.addContent(channelDescriptionEl);
        Element channelItemsEl = new Element("items", s_rssNS);
        channelEl.addContent(channelItemsEl);
        Element itemsSeqEl = new Element("Seq", s_rdfNS);
        channelItemsEl.addContent(itemsSeqEl);
        RSSItemCollection items = channel.getItems();
        while (items.next()) {
            RSSItem item = items.getItem();
            seqEl = new Element("li", s_rdfNS);
            seqEl.setAttribute("resource", item.getLink(), s_rdfNS);
            itemsSeqEl.addContent(seqEl);
            Element itemEl = new Element("item", s_rssNS);
            itemEl.setAttribute("about", item.getLink(), s_rdfNS);
            rdfEl.addContent(itemEl);
            titleEl = new Element("title", s_rssNS);
            titleEl.setText(item.getTitle());
            itemEl.addContent(titleEl);
            linkEl = new Element("link", s_rssNS);
            linkEl.setText(item.getLink());
            itemEl.addContent(linkEl);
            if (item.getDescription() == null) continue;
            Element descEl = new Element("description", s_rssNS);
            descEl.setText(item.getDescription());
            itemEl.addContent(descEl);
        }
        RSSImage image = channel.getImage();
        if (image != null) {
            seqEl = new Element("image", s_rdfNS);
            seqEl.setAttribute("resource", image.getURL(), s_rdfNS);
            channelEl.addContent(seqEl);
            Element imageEl = new Element("image", s_rssNS);
            imageEl.setAttribute("about", image.getURL(), s_rdfNS);
            rdfEl.addContent(imageEl);
            titleEl = new Element("title", s_rssNS);
            titleEl.setText(image.getTitle());
            imageEl.addContent(titleEl);
            linkEl = new Element("link", s_rssNS);
            linkEl.setText(image.getLink());
            imageEl.addContent(linkEl);
            Element urlEl = new Element("url", s_rssNS);
            urlEl.setText(image.getURL());
            imageEl.addContent(urlEl);
        }
        return rdfEl;
    }

    public static org.w3c.dom.Element generateDOM(RSSChannel channel) {
        Element jdomContent = RSSRenderer.generateJDOM(channel);
        DOMOutputter convertor = new DOMOutputter();
        org.w3c.dom.Element domContent = null;
        try {
            domContent = convertor.output(jdomContent);
        }
        catch (JDOMException e) {
            throw new UncheckedWrapperException("cannot convert JDOM element to DOM", (Throwable)e);
        }
        return domContent;
    }

    public static com.arsdigita.xml.Element generateXML(RSSChannel channel) {
        org.w3c.dom.Element domContent = RSSRenderer.generateDOM(channel);
        return new WrapperElement(domContent);
    }

    private static class WrapperElement
    extends com.arsdigita.xml.Element {
        public WrapperElement(org.w3c.dom.Element element) {
            this.m_element = element;
        }
    }
}

