/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed;

import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.ui.CategorizationTree;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainCollectionIterator;
import com.arsdigita.kernel.URLService;
import com.arsdigita.kernel.User;
import com.arsdigita.london.terms.Domain;
import com.arsdigita.london.terms.Term;
import com.arsdigita.persistence.OID;
import com.arsdigita.rssfeed.Feed;
import com.arsdigita.rssfeed.FeedCollection;
import com.arsdigita.rssfeed.RSSFeedConfig;
import com.arsdigita.util.StringUtils;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.output.XMLOutputter;

public class RSSService {
    private static Logger s_log = Logger.getLogger(RSSService.class);
    private static final RSSFeedConfig s_config = RSSFeedConfig.getConfig();

    public static RSSFeedConfig getConfig() {
        return s_config;
    }

    public static void generateChannel(BigDecimal categoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Category cat = new Category(categoryId);
        boolean useLAWs = "laws-1.0".equals(request.getParameter("extension"));
        boolean useESD = "laws-esd".equals(request.getParameter("extension"));
        if (useESD) {
            useLAWs = true;
        }
        Namespace rdfNS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        Namespace rssNS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");
        Namespace dcNS = Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/");
        Namespace egmsNS = null;
        egmsNS = useESD ? Namespace.getNamespace((String)"esd", (String)"http://www.esd.org.uk/standards/esd/3.0/esd.rdfs") : Namespace.getNamespace((String)"egms", (String)"http://www.esd.org.uk/standards/egms/3.0/egms.rdfs");
        Namespace lgclNS = Namespace.getNamespace((String)"lgcl", (String)"http://www.esd.org.uk/standards/lgcl/1.03/lgcl.rdfs");
        Element rdf = new Element("RDF", "rdf", rdfNS.getURI());
        rdf.addNamespaceDeclaration(rssNS);
        if (useLAWs) {
            rdf.addNamespaceDeclaration(dcNS);
            rdf.addNamespaceDeclaration(egmsNS);
            rdf.addNamespaceDeclaration(lgclNS);
        }
        Element channel = new Element("channel", rssNS);
        channel.setAttribute("about", URL.here((HttpServletRequest)request, (String)"/rss/").getURL(), rdfNS);
        rdf.addContent(channel);
        Element channelTitle = new Element("title", rssNS);
        channelTitle.setText(cat.getName());
        channel.addContent(channelTitle);
        if (useLAWs) {
            Element channelDCTitle = new Element("title", dcNS);
            channelDCTitle.setText(cat.getName());
            channel.addContent(channelDCTitle);
        }
        Element channelLink = new Element("link", rssNS);
        channelLink.setText(URL.there((HttpServletRequest)request, null).getServerURI().concat(URLService.locate((OID)cat.getOID())));
        channel.addContent(channelLink);
        Element channelDescription = new Element("description", rssNS);
        channelDescription.setText(cat.getDescription());
        channel.addContent(channelDescription);
        Element channelItems = new Element("items", rssNS);
        channel.addContent(channelItems);
        Element itemsSeq = new Element("Seq", rdfNS);
        channelItems.addContent(itemsSeq);
        TreeSet<NewestFirstItem> items = new TreeSet<NewestFirstItem>();
        CategorizedCollection objects = cat.getObjects("com.arsdigita.cms.ContentItem");
        while (objects.next()) {
            ContentItem item = (ContentItem)objects.getACSObject();
            s_log.debug((Object)("item: " + item.getDisplayName()));
            if (!"live".equals(item.getVersion())) continue;
            items.add(new NewestFirstItem(item));
        }
        Iterator iter = items.iterator();
        int max = 10;
        int current = 0;
        while (iter.hasNext() && ++current <= max) {
            String title;
            NewestFirstItem itemWrapper = (NewestFirstItem)iter.next();
            ContentItem item = itemWrapper.getContentItem();
            String description = "";
            try {
                ContentItem primary = ((ContentBundle)item).getPrimaryInstance();
                try {
                    ContentPage page = (ContentPage)primary;
                    title = page.getTitle();
                    description = page.getSearchSummary();
                }
                catch (ClassCastException e) {
                    title = primary.getDisplayName();
                }
            }
            catch (ClassCastException e) {
                title = item.getDisplayName();
            }
            String itemURL = URL.there((HttpServletRequest)request, null).getServerURI().concat(URLService.locate((OID)item.getOID()));
            s_log.debug((Object)"item is live");
            Element seqEl = new Element("li", rdfNS);
            seqEl.setAttribute("resource", itemURL, rdfNS);
            itemsSeq.addContent(seqEl);
            Element itemEl = new Element("item", rssNS);
            itemEl.setAttribute("about", itemURL, rdfNS);
            rdf.addContent(itemEl);
            Element titleEl = new Element("title", rssNS);
            titleEl.setText(title);
            itemEl.addContent(titleEl);
            Element linkEl = new Element("link", rssNS);
            linkEl.setText(itemURL);
            itemEl.addContent(linkEl);
            if (description != null) {
                Element descEl = new Element("description", rssNS);
                descEl.setText(StringUtils.truncateString((String)description, (int)100, (boolean)true) + "...");
                itemEl.addContent(descEl);
            }
            if (!useLAWs) continue;
            Element dcTitleEl = new Element("title", dcNS);
            dcTitleEl.setText(title);
            itemEl.addContent(dcTitleEl);
            User creatorUser = item.getCreationUser();
            String creator = "Not specified";
            if (creatorUser != null) {
                creator = creatorUser.getName();
            }
            Element dcCreatorEl = new Element("creator", dcNS);
            dcCreatorEl.setText(creator);
            itemEl.addContent(dcCreatorEl);
            Date dcDate = item.getCreationDate();
            String dcDateString = "Not specified";
            if (dcDate != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                dcDateString = sdf.format(dcDate);
            }
            Element dcDateEl = new Element("date", dcNS);
            dcDateEl.setText(dcDateString);
            itemEl.addContent(dcDateEl);
            Element subjectCategoryEl = new Element("subjectCategory", egmsNS);
            itemEl.addContent(subjectCategoryEl);
            Element subjectBagEl = new Element("Bag", rdfNS);
            subjectCategoryEl.addContent(subjectBagEl);
            Domain lgclDomain = Domain.retrieve((String)"LGCL");
            DomainCollection terms = lgclDomain.getTerms();
            terms.addEqualsFilter("model.childObjects.id", (Object)item.getID());
            if (terms == null) continue;
            DomainCollectionIterator it = new DomainCollectionIterator(terms);
            while (it.hasNext()) {
                Term term = (Term)it.next();
                String name = term.getName();
                String urlName = RSSService.toUpperCamel(name);
                Element liEl = new Element("li", rdfNS);
                subjectBagEl.addContent(liEl);
                Element categoryEl = new Element(urlName, lgclNS);
                liEl.addContent(categoryEl);
                Element rdfValueEl = new Element("value", rdfNS);
                rdfValueEl.setText(name);
                categoryEl.addContent(rdfValueEl);
            }
        }
        Document doc = new Document();
        if (RSSService.getConfig().getPIxslt() != null) {
            doc.addContent(new ProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + RSSService.getConfig().getPIxslt() + "\""));
        }
        doc.setRootElement(rdf);
        response.setContentType("text/xml; charset=UTF-8");
        XMLOutputter xmlOutput = new XMLOutputter("UTF-8");
        xmlOutput.setNewlines(true);
        xmlOutput.setIndent(true);
        xmlOutput.output(doc, (Writer)response.getWriter());
    }

    public static void generateChannelList(Category root, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Namespace rdfNS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        Namespace rssNS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");
        Element rdf = new Element("RDF", "rdf", rdfNS.getURI());
        rdf.addNamespaceDeclaration(rssNS);
        Element channel = new Element("channel", rssNS);
        channel.setAttribute("about", URL.here((HttpServletRequest)request, (String)"/rss/").getURL(), rdfNS);
        rdf.addContent(channel);
        Element channelTitle = new Element("title", rssNS);
        channelTitle.setText("Channel Index");
        channel.addContent(channelTitle);
        Element channelLink = new Element("link", rssNS);
        channelLink.setText(URL.here((HttpServletRequest)request, (String)"/rss/").getURL());
        channel.addContent(channelLink);
        Element channelDescription = new Element("description", rssNS);
        channelDescription.setText("The list of content feeds");
        channel.addContent(channelDescription);
        Element channelItems = new Element("items", rssNS);
        channel.addContent(channelItems);
        Element itemsSeq = new Element("Seq", rdfNS);
        channelItems.addContent(itemsSeq);
        Map cats = CategorizationTree.getSubtreePath((Category)root);
        s_log.debug((Object)"Get categories");
        Iterator i = cats.keySet().iterator();
        s_log.debug((Object)"About to iterate");
        while (i.hasNext()) {
            String path = (String)i.next();
            Category cat = (Category)cats.get(path);
            if (cat.getID().equals(root.getID())) continue;
            s_log.debug((Object)("GOt sub cat " + path + " id " + cat.getID()));
            ParameterMap params = new ParameterMap();
            params.setParameter("id", (Object)cat.getID());
            URL url = URL.here((HttpServletRequest)request, (String)"/rss/channel.rss", (ParameterMap)params);
            Element seqEl = new Element("li", rdfNS);
            seqEl.setAttribute("resource", url.getURL(), rdfNS);
            itemsSeq.addContent(seqEl);
            Element itemEl = new Element("item", rssNS);
            itemEl.setAttribute("about", url.getURL(), rdfNS);
            rdf.addContent(itemEl);
            Element titleEl = new Element("title", rssNS);
            titleEl.setText(path);
            itemEl.addContent(titleEl);
            Element linkEl = new Element("link", rssNS);
            linkEl.setText(url.getURL());
            itemEl.addContent(linkEl);
            if (cat.getDescription() == null) continue;
            Element descEl = new Element("description", rssNS);
            descEl.setText(cat.getDescription());
            itemEl.addContent(descEl);
        }
        s_log.debug((Object)"All done");
        Document doc = new Document(rdf);
        response.setContentType("text/xml; charset=UTF-8");
        XMLOutputter xmlOutput = new XMLOutputter("UTF-8");
        xmlOutput.setNewlines(true);
        xmlOutput.setIndent(true);
        xmlOutput.output(doc, (Writer)response.getWriter());
    }

    public static void generateFeedList(boolean acsj, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Namespace rdfNS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        Namespace rssNS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");
        Element rdf = new Element("RDF", "rdf", rdfNS.getURI());
        rdf.addNamespaceDeclaration(rssNS);
        Element channel = new Element("channel", rssNS);
        channel.setAttribute("about", URL.here((HttpServletRequest)request, (String)"/rss/").getURL(), rdfNS);
        rdf.addContent(channel);
        Element channelTitle = new Element("title", rssNS);
        channelTitle.setText("Channel Index");
        channel.addContent(channelTitle);
        Element channelLink = new Element("link", rssNS);
        channelLink.setText(URL.here((HttpServletRequest)request, (String)"/rss/").getURL());
        channel.addContent(channelLink);
        Element channelDescription = new Element("description", rssNS);
        channelDescription.setText("The list of server feeds");
        channel.addContent(channelDescription);
        Element channelItems = new Element("items", rssNS);
        channel.addContent(channelItems);
        Element itemsSeq = new Element("Seq", rdfNS);
        channelItems.addContent(itemsSeq);
        FeedCollection feeds = Feed.retrieveAll();
        feeds.filterACSJFeeds(acsj);
        while (feeds.next()) {
            Feed feed = feeds.getFeed();
            Element seqEl = new Element("li", rdfNS);
            seqEl.setAttribute("resource", feed.getURL(), rdfNS);
            itemsSeq.addContent(seqEl);
            Element itemEl = new Element("item", rssNS);
            itemEl.setAttribute("about", feed.getURL(), rdfNS);
            rdf.addContent(itemEl);
            Element titleEl = new Element("title", rssNS);
            titleEl.setText(feed.getTitle());
            itemEl.addContent(titleEl);
            Element linkEl = new Element("link", rssNS);
            linkEl.setText(feed.getURL());
            itemEl.addContent(linkEl);
            String desc = feed.getDescription();
            if (desc == null) continue;
            Element descEl = new Element("description", rssNS);
            descEl.setText(desc);
            itemEl.addContent(descEl);
        }
        Document doc = new Document(rdf);
        response.setContentType("text/xml; charset=UTF-8");
        XMLOutputter xmlOutput = new XMLOutputter("UTF-8");
        xmlOutput.setNewlines(true);
        xmlOutput.setIndent(true);
        xmlOutput.output(doc, (Writer)response.getWriter());
    }

    public static String toUpperCamel(String termName) {
        String upperCamel = "";
        if (termName != null) {
            StringTokenizer tokens = new StringTokenizer(termName);
            while (tokens.hasMoreTokens()) {
                String word = tokens.nextToken();
                if (word.length() <= 1) {
                    upperCamel = upperCamel + word.toUpperCase();
                    continue;
                }
                upperCamel = upperCamel + word.substring(0, 1).toUpperCase() + word.substring(1, word.length());
            }
        }
        return upperCamel;
    }

    private static class NewestFirstItem
    implements Comparable {
        private ContentItem m_item;
        private BigDecimal m_liveID;

        public NewestFirstItem(ContentItem item) {
            this.m_item = item;
            this.m_liveID = item.getID();
        }

        public ContentItem getContentItem() {
            return this.m_item;
        }

        public BigDecimal getLiveID() {
            return this.m_liveID;
        }

        public int compareTo(Object o) {
            if (o instanceof NewestFirstItem) {
                return -1 * this.m_liveID.compareTo(((NewestFirstItem)o).getLiveID());
            }
            throw new ClassCastException("Must compare to NewestFirstItem");
        }

        public boolean equals(Object o) {
            if (o instanceof NewestFirstItem) {
                return this.m_item.equals((Object)((NewestFirstItem)o).getContentItem());
            }
            return false;
        }
    }
}

