/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.rssfeed.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.rssfeed.ui.admin.FeedForm;
import com.arsdigita.rssfeed.ui.admin.FeedSelectionModel;

public class ProviderFeedForm
extends FeedForm {
    private TextField m_url;
    private RadioGroup m_external;
    private Option m_external_no;
    private Option m_external_yes;

    public ProviderFeedForm(FeedSelectionModel feed) {
        super("provider", true, feed);
    }

    @Override
    protected void addWidgets(String name) {
        super.addWidgets(name);
        this.m_url = new TextField((ParameterModel)new StringParameter(name + "-host"));
        this.m_url.setSize(50);
        this.add((Component)new Label("Provider Host:"));
        this.add((Component)this.m_url);
        this.m_external = new RadioGroup(name + "-external");
        this.m_external.setLayout(2);
        this.m_external_yes = new Option("yes", "External feed list");
        this.m_external_no = new Option("no", "CMS content feed list");
        this.m_external.addOption(this.m_external_no);
        this.m_external.addOption(this.m_external_yes);
        this.add((Component)new Label("Feed:"));
        this.add((Component)this.m_external);
    }

    @Override
    protected String getURL(PageState state) {
        String postfix = this.m_external_no.getValue().equals(this.m_external.getValue(state)) ? "/channels/rss/index.rss" : "/channels/rss/external.rss";
        return "http://" + (String)this.m_url.getValue(state) + postfix;
    }

    @Override
    protected void setURL(PageState state, String url) {
        if (url != null && url.length() > 8) {
            url = url.substring(7);
            int pos = url.indexOf("/");
            if (url.endsWith("/channels/rss/external.rss")) {
                this.m_external.setValue(state, (Object)this.m_external_yes.getValue());
            } else {
                this.m_external.setValue(state, (Object)this.m_external_no.getValue());
            }
            if (pos > 0) {
                url = url.substring(0, pos);
            }
        } else {
            this.m_external.setValue(state, (Object)this.m_external_no.getValue());
        }
        this.m_url.setValue(state, (Object)url);
    }
}

