/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.FAQItem;
import com.arsdigita.cms.contenttypes.ui.FAQItemPropertiesStep;
import com.arsdigita.cms.contenttypes.util.FAQGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.BasicPageForm;

public class FAQItemPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private FAQItemPropertiesStep m_step;
    public static final String QUESTION = "question";
    public static final String ANSWER = "answer";
    public static final String SECTION_NAME = "sectionName";
    public static final String ID = "FAQItem_edit";

    public FAQItemPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public FAQItemPropertyForm(ItemSelectionModel itemModel, FAQItemPropertiesStep step) {
        super(ID, itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.question")));
        StringParameter questionParam = new StringParameter(QUESTION);
        questionParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        TextArea question = new TextArea((ParameterModel)questionParam);
        question.setCols(40);
        question.setRows(5);
        this.add((Component)question);
        this.add((Component)new Label(FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.answer")));
        StringParameter answerParam = new StringParameter(ANSWER);
        answerParam.addParameterListener((ParameterListener)new NotNullValidationListener());
        TextArea answer = new TextArea((ParameterModel)answerParam);
        answer.setCols(40);
        answer.setRows(5);
        this.add((Component)answer);
        this.add((Component)new Label(FAQGlobalizationUtil.globalize("cms.contenttypes.ui.faq.sectionName")));
        StringParameter sectionNameParam = new StringParameter(SECTION_NAME);
        TextField sectionName = new TextField((ParameterModel)sectionNameParam);
        this.add((Component)sectionName);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        FAQItem faqItem = (FAQItem)super.initBasicWidgets(fse);
        data.put((Object)QUESTION, (Object)faqItem.getQuestion());
        data.put((Object)ANSWER, (Object)faqItem.getAnswer());
        data.put((Object)SECTION_NAME, (Object)faqItem.getSectionName());
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        FAQItem faqItem = (FAQItem)super.processBasicWidgets(fse);
        if (faqItem != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            faqItem.setQuestion((String)data.get((Object)QUESTION));
            faqItem.setAnswer((String)data.get((Object)ANSWER));
            faqItem.setSectionName((String)data.get((Object)SECTION_NAME));
            faqItem.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

