/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.ArticleInCollectedVolume;
import com.arsdigita.cms.contenttypes.ArticleInCollectedVolumeBundle;
import com.arsdigita.cms.contenttypes.Publication;
import com.arsdigita.cms.contenttypes.PublicationBundle;
import com.arsdigita.cms.scipublications.importer.csv.AbstractPublicationImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;

class ArticleInCollectedVolumeImporter
extends AbstractPublicationImporter<ArticleInCollectedVolume> {
    public ArticleInCollectedVolumeImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    public ArticleInCollectedVolume importPublication() {
        ArticleInCollectedVolume article = (ArticleInCollectedVolume)super.importPublication();
        CsvLine data = this.getData();
        PublicationImportReport report = this.getReport();
        ImporterUtil importerUtil = this.getImporterUtil();
        this.processPagesFrom(article);
        this.processPagesTo(article);
        if (data.getChapter() != null && !data.getChapter().isEmpty()) {
            if (!this.isPretend()) {
                article.setChapter(data.getChapter());
            }
            report.addField(new FieldImportReport("Chapter", data.getChapter()));
        }
        if (data.getCollectedVolume() != null && !data.getCollectedVolume().isEmpty()) {
            report.setCollectedVolume(importerUtil.processCollectedVolume(article, data.getCollectedVolume(), data.getYear(), this.parseAuthors(data.getCollectedVolumeAuthors()), data.getPublisher(), data.getPlace(), null, this.isPretend()));
        }
        return article;
    }

    private void processPagesFrom(ArticleInCollectedVolume publication) {
        if (this.getData().getPageFrom() != null && !this.getData().getPageFrom().isEmpty()) {
            try {
                int pagesFrom = Integer.parseInt(this.getData().getPageFrom());
                if (!this.isPretend()) {
                    publication.setPagesFrom(Integer.valueOf(pagesFrom));
                }
                this.getReport().addField(new FieldImportReport("Pages from", this.getData().getPageFrom()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse pageFrom data in line '%d'.", this.getData().getLineNumber()));
            }
        }
    }

    private void processPagesTo(ArticleInCollectedVolume publication) {
        if (this.getData().getPageFrom() != null && !this.getData().getPageFrom().isEmpty()) {
            try {
                int pagesTo = Integer.parseInt(this.getData().getPageTo());
                if (!this.isPretend()) {
                    publication.setPagesTo(Integer.valueOf(pagesTo));
                }
                this.getReport().addField(new FieldImportReport("Pages to", this.getData().getPageTo()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse pageTo data in line '%d'.", this.getData().getLineNumber()));
            }
        }
    }

    @Override
    protected ArticleInCollectedVolume createPublication() {
        if (this.isPretend()) {
            return null;
        }
        return new ArticleInCollectedVolume();
    }

    @Override
    protected PublicationBundle createBundle(ArticleInCollectedVolume article) {
        if (this.isPretend()) {
            return null;
        }
        return new ArticleInCollectedVolumeBundle((ContentItem)article);
    }

    @Override
    protected Integer getFolderId() {
        return Publication.getConfig().getDefaultArticlesInCollectedVolumeFolder();
    }
}

