/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.ArticleInJournal;
import com.arsdigita.cms.contenttypes.ArticleInJournalBundle;
import com.arsdigita.cms.contenttypes.Publication;
import com.arsdigita.cms.contenttypes.PublicationBundle;
import com.arsdigita.cms.scipublications.importer.csv.AbstractPublicationImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.JournalImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

class ArticleInJournalImporter
extends AbstractPublicationImporter<ArticleInJournal> {
    protected ArticleInJournalImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    public ArticleInJournal importPublication() {
        ArticleInJournal article = (ArticleInJournal)super.importPublication();
        CsvLine data = this.getData();
        PublicationImportReport report = this.getReport();
        ImporterUtil importerUtil = this.getImporterUtil();
        this.processVolume(article);
        if (data.getIssue() != null && !data.getIssue().isEmpty()) {
            if (!this.isPretend()) {
                article.setIssue(data.getIssue());
            }
            report.addField(new FieldImportReport("Issue", data.getIssue()));
        }
        this.processPagesFrom(article);
        this.processPagesTo(article);
        this.processPublicationDate(article);
        if (data.getJournal() != null && !data.getJournal().isEmpty()) {
            JournalImportReport journalReport = importerUtil.processJournal(article, data.getJournal(), this.isPretend());
            report.setJournal(journalReport);
        }
        return article;
    }

    private void processVolume(ArticleInJournal article) {
        if (this.getData().getVolumeOfJournal() != null && !this.getData().getVolumeOfJournal().isEmpty()) {
            try {
                int volume = Integer.parseInt(this.getData().getVolumeOfJournal());
                if (!this.isPretend()) {
                    article.setVolume(Integer.valueOf(volume));
                }
                this.getReport().addField(new FieldImportReport("Volume", this.getData().getVolumeOfJournal()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse volume data in line '%d'.", this.getData().getLineNumber()));
            }
        }
    }

    private void processPagesFrom(ArticleInJournal publication) {
        if (this.getData().getPageFrom() != null && !this.getData().getPageFrom().isEmpty()) {
            try {
                int pagesFrom = Integer.parseInt(this.getData().getPageFrom());
                if (!this.isPretend()) {
                    publication.setPagesFrom(Integer.valueOf(pagesFrom));
                }
                this.getReport().addField(new FieldImportReport("Pages from", this.getData().getPageFrom()));
            }
            catch (NumberFormatException ex) {
                this.getReport().addMessage(String.format("Failed to parse pageFrom data in line '%d'.", this.getData().getLineNumber()));
            }
        }
    }

    private void processPagesTo(ArticleInJournal publication) {
        try {
            int pagesTo = Integer.parseInt(this.getData().getPageTo());
            if (!this.isPretend()) {
                publication.setPagesTo(Integer.valueOf(pagesTo));
            }
            this.getReport().addField(new FieldImportReport("Pages to", this.getData().getPageTo()));
        }
        catch (NumberFormatException ex) {
            this.getReport().addMessage(String.format("Failed to parse pageTo data in line '%d'.", this.getData().getLineNumber()));
        }
    }

    private void processPublicationDate(ArticleInJournal article) {
        if (this.getData().getPublicationDate() != null && !this.getData().getPublicationDate().isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-mm-dd");
            try {
                Date date = dateFormat.parse(this.getData().getPublicationDate());
                if (!this.isPretend()) {
                    article.setPublicationDate(date);
                }
                this.getReport().addField(new FieldImportReport("Publication date", this.getData().getPublicationDate()));
            }
            catch (ParseException ex) {
                this.getReport().addMessage(String.format("Failed to parse publication date in line %d.", this.getData().getLineNumber()));
            }
        }
    }

    @Override
    protected ArticleInJournal createPublication() {
        if (this.isPretend()) {
            return null;
        }
        return new ArticleInJournal();
    }

    @Override
    protected PublicationBundle createBundle(ArticleInJournal article) {
        if (this.isPretend()) {
            return null;
        }
        return new ArticleInJournalBundle((ContentItem)article);
    }

    @Override
    protected Integer getFolderId() {
        return Publication.getConfig().getDefaultArticlesInJournalFolder();
    }
}

