/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.Proceedings;
import com.arsdigita.cms.contenttypes.ProceedingsBundle;
import com.arsdigita.cms.contenttypes.Publication;
import com.arsdigita.cms.contenttypes.PublicationBundle;
import com.arsdigita.cms.scipublications.importer.csv.AbstractPublicationWithPublisherImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;

class ProceedingsImporter
extends AbstractPublicationWithPublisherImporter<Proceedings> {
    public ProceedingsImporter(CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        super(data, report, pretend, importerUtil);
    }

    @Override
    public Proceedings importPublication() {
        Proceedings proceedings = (Proceedings)super.importPublication();
        CsvLine data = this.getData();
        PublicationImportReport report = this.getReport();
        if (data.getConference() != null && !data.getConference().isEmpty()) {
            if (!this.isPretend()) {
                proceedings.setNameOfConference(data.getConference());
            }
            report.addField(new FieldImportReport("Name of conference", data.getConference()));
        }
        return proceedings;
    }

    @Override
    protected Proceedings createPublication() {
        if (this.isPretend()) {
            return null;
        }
        return new Proceedings();
    }

    @Override
    protected PublicationBundle createBundle(Proceedings proceedings) {
        if (this.isPretend()) {
            return null;
        }
        return new ProceedingsBundle((ContentItem)proceedings);
    }

    @Override
    protected Integer getFolderId() {
        return Publication.getConfig().getDefaultProceedingsFolder();
    }
}

