/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.scipublications.importer.csv;

import com.arsdigita.cms.contenttypes.ArticleInCollectedVolume;
import com.arsdigita.cms.contenttypes.ArticleInJournal;
import com.arsdigita.cms.contenttypes.CollectedVolume;
import com.arsdigita.cms.contenttypes.Expertise;
import com.arsdigita.cms.contenttypes.GreyLiterature;
import com.arsdigita.cms.contenttypes.InProceedings;
import com.arsdigita.cms.contenttypes.InternetArticle;
import com.arsdigita.cms.contenttypes.Monograph;
import com.arsdigita.cms.contenttypes.Proceedings;
import com.arsdigita.cms.contenttypes.Review;
import com.arsdigita.cms.contenttypes.WorkingPaper;
import com.arsdigita.cms.scipublications.imexporter.PublicationFormat;
import com.arsdigita.cms.scipublications.importer.SciPublicationsImportException;
import com.arsdigita.cms.scipublications.importer.SciPublicationsImporter;
import com.arsdigita.cms.scipublications.importer.csv.ArticleInCollectedVolumeImporter;
import com.arsdigita.cms.scipublications.importer.csv.ArticleInJournalImporter;
import com.arsdigita.cms.scipublications.importer.csv.CollectedVolumeImporter;
import com.arsdigita.cms.scipublications.importer.csv.CsvImporterConfig;
import com.arsdigita.cms.scipublications.importer.csv.CsvLine;
import com.arsdigita.cms.scipublications.importer.csv.ExpertiseImporter;
import com.arsdigita.cms.scipublications.importer.csv.GreyLiteratureImporter;
import com.arsdigita.cms.scipublications.importer.csv.InProceedingsImporter;
import com.arsdigita.cms.scipublications.importer.csv.InternetArticleImporter;
import com.arsdigita.cms.scipublications.importer.csv.MonographImporter;
import com.arsdigita.cms.scipublications.importer.csv.ProceedingsImporter;
import com.arsdigita.cms.scipublications.importer.csv.ReviewImporter;
import com.arsdigita.cms.scipublications.importer.csv.WorkingPaperImporter;
import com.arsdigita.cms.scipublications.importer.report.FieldImportReport;
import com.arsdigita.cms.scipublications.importer.report.ImportReport;
import com.arsdigita.cms.scipublications.importer.report.PublicationImportReport;
import com.arsdigita.cms.scipublications.importer.util.ImporterUtil;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import java.util.Arrays;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.log4j.Logger;

public class PublicationsImporter
implements SciPublicationsImporter {
    private static final Logger LOGGER = Logger.getLogger(PublicationsImporter.class);
    private static final String LINE_SEP = "\n";
    private static final String COL_SEP = "\t";
    private static final CsvImporterConfig CONFIG = new CsvImporterConfig();

    public static CsvImporterConfig getConfig() {
        return CONFIG;
    }

    public PublicationFormat getSupportedFormat() {
        try {
            return new PublicationFormat("CSV", new MimeType("text", "csv"), "csv");
        }
        catch (MimeTypeParseException ex) {
            LOGGER.warn((Object)"Failed to create MimeType for PublicationFormat.Using null mimetype instead. Cause: ", (Throwable)ex);
            return new PublicationFormat("CSV", null, "csv");
        }
    }

    public ImportReport importPublications(String publications, Map<String, String> params, boolean pretend, boolean publishNewItems) throws SciPublicationsImportException {
        String[] linesWithHeader = publications.split(LINE_SEP);
        String[] lines = Arrays.copyOfRange(linesWithHeader, 1, linesWithHeader.length);
        ImportReport report = new ImportReport();
        ImporterUtil importerUtil = new ImporterUtil(publishNewItems);
        report.setImporter("CSV Importer");
        report.setPretend(pretend);
        Session session = SessionManager.getSession();
        TransactionContext tctx = session.getTransactionContext();
        System.out.printf("Import publications...\n", new Object[0]);
        int lineNumber = 2;
        for (String line : lines) {
            tctx.beginTxn();
            try {
                System.out.printf("Processing publication %d...\n", lineNumber);
                PublicationImportReport result = this.importPublication(line, lineNumber, publishNewItems, pretend, importerUtil);
                report.addPublication(result);
            }
            catch (Exception ex) {
                tctx.abortTxn();
                throw new SciPublicationsImportException(ex);
            }
            tctx.commitTxn();
            ++lineNumber;
        }
        return report;
    }

    private PublicationImportReport importPublication(String line, int lineNumber, boolean publishNewItems, boolean pretend, ImporterUtil importerUtil) {
        PublicationImportReport report = new PublicationImportReport();
        String[] cols = line.split(COL_SEP, -37);
        if (cols.length != 37) {
            report.setSuccessful(false);
            report.addMessage(String.format("!!! Wrong number of columns. Exepcted 37 columns but found %d columns. Skiping line %d!\n", cols.length, lineNumber));
            return report;
        }
        CsvLine data = new CsvLine(cols, lineNumber);
        if (ArticleInCollectedVolume.class.getSimpleName().equals(data.getType())) {
            this.processArticleInCollectedVolume(publishNewItems, data, report, pretend, importerUtil);
        } else if (ArticleInJournal.class.getSimpleName().equals(data.getType())) {
            this.processArticleInJournal(publishNewItems, data, report, pretend, importerUtil);
        } else if (CollectedVolume.class.getSimpleName().equals(data.getType())) {
            this.processCollectedVolume(publishNewItems, data, report, pretend, importerUtil);
        } else if (Expertise.class.getSimpleName().equals(data.getType())) {
            this.processExpertise(publishNewItems, data, report, pretend, importerUtil);
        } else if (GreyLiterature.class.getSimpleName().equals(data.getType())) {
            this.processGreyLiterature(publishNewItems, data, report, pretend, importerUtil);
        } else if (InProceedings.class.getSimpleName().equals(data.getType())) {
            this.processInProceedings(publishNewItems, data, report, pretend, importerUtil);
        } else if (InternetArticle.class.getSimpleName().equals(data.getType())) {
            this.processInternetArticle(publishNewItems, data, report, pretend, importerUtil);
        } else if (Monograph.class.getSimpleName().equals(data.getType())) {
            this.processMonograph(publishNewItems, data, report, pretend, importerUtil);
        } else if (Proceedings.class.getSimpleName().equals(data.getType())) {
            this.processProceedings(publishNewItems, data, report, pretend, importerUtil);
        } else if (Review.class.getSimpleName().equals(data.getType())) {
            this.processReview(publishNewItems, data, report, pretend, importerUtil);
        } else if (WorkingPaper.class.getSimpleName().equals(data.getType())) {
            this.processWorkingPaper(publishNewItems, data, report, pretend, importerUtil);
        }
        return report;
    }

    private void processArticleInCollectedVolume(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, ArticleInCollectedVolume.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        ArticleInCollectedVolumeImporter importer = new ArticleInCollectedVolumeImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processArticleInJournal(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, ArticleInJournal.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        ArticleInJournalImporter importer = new ArticleInJournalImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processCollectedVolume(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, CollectedVolume.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        CollectedVolumeImporter importer = new CollectedVolumeImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processExpertise(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, Expertise.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        ExpertiseImporter importer = new ExpertiseImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processGreyLiterature(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, GreyLiterature.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        GreyLiteratureImporter importer = new GreyLiteratureImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processInProceedings(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, InProceedings.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        InProceedingsImporter importer = new InProceedingsImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processInternetArticle(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, InternetArticle.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        InternetArticleImporter importer = new InternetArticleImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processMonograph(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, Monograph.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        MonographImporter importer = new MonographImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processProceedings(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, Proceedings.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        ProceedingsImporter importer = new ProceedingsImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processReview(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, Review.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        ReviewImporter importer = new ReviewImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private void processWorkingPaper(boolean publishNewItems, CsvLine data, PublicationImportReport report, boolean pretend, ImporterUtil importerUtil) {
        if (this.isPublicationAlreadyInDatabase(data, WorkingPaper.class.getSimpleName(), report)) {
            report.setSuccessful(true);
            return;
        }
        WorkingPaperImporter importer = new WorkingPaperImporter(data, report, pretend, importerUtil);
        importer.doImport(publishNewItems);
    }

    private boolean isPublicationAlreadyInDatabase(CsvLine data, String type, PublicationImportReport report) {
        int yearOfPublication;
        String title = data.getTitle();
        String year = data.getYear();
        try {
            yearOfPublication = Integer.parseInt(year);
        }
        catch (NumberFormatException ex) {
            yearOfPublication = 0;
        }
        Session session = SessionManager.getSession();
        DataCollection collection = session.retrieve("com.arsdigita.cms.contenttypes.Publication");
        FilterFactory filterFactory = collection.getFilterFactory();
        Filter titleFilter = filterFactory.equals("title", (Object)title);
        Filter yearFilter = filterFactory.equals("yearOfPublication", (Object)yearOfPublication);
        collection.addFilter(titleFilter);
        collection.addFilter(yearFilter);
        boolean result = !collection.isEmpty();
        collection.close();
        report.setTitle(title);
        report.setType(type);
        report.addField(new FieldImportReport("Year of publication", year));
        report.setAlreadyInDatabase(result);
        return result;
    }

    static {
        CONFIG.load();
    }
}

